/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.Comparator;

public class AlphanumComparator
implements Comparator<String> {
    int skip;

    private final boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private final String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        int markstart = marker;
        char c = s.charAt(marker);
        boolean startIsDigit = this.isDigit(c);
        if (c == '0') {
            while (marker + 1 < slength && s.charAt(marker + 1) == '0') {
                ++marker;
            }
            if (marker + 1 < slength && this.isDigit(s.charAt(marker + 1))) {
                c = s.charAt(++marker);
            }
        }
        chunk.append(c);
        while (++marker < slength && this.isDigit(c = s.charAt(marker)) == startIsDigit) {
            chunk.append(c);
        }
        this.skip = marker - markstart;
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        int length1 = s1.length();
        int length2 = s2.length();
        int result = length1 - length2;
        int marker1 = 0;
        int marker2 = 0;
        while (marker1 < length1 && marker2 < length2) {
            String chunk1 = this.getChunk(s1, length1, marker1);
            marker1 += this.skip;
            String chunk2 = this.getChunk(s2, length2, marker2);
            marker2 += this.skip;
            if (this.isDigit(chunk1.charAt(0)) && this.isDigit(chunk2.charAt(0))) {
                int chunkLength1 = chunk1.length();
                result = chunkLength1 - chunk2.length();
                if (result == 0) {
                    for (int i = 0; i < chunkLength1 && (result = chunk1.charAt(i) - chunk2.charAt(i)) == 0; ++i) {
                    }
                }
            } else {
                result = chunk1.compareTo(chunk2);
            }
            if (result == 0) continue;
            break;
        }
        if (result == 0 && marker1 == length1 && marker2 < length2) {
            return -1;
        }
        if (result == 0 && marker1 < length1 && marker2 == length2) {
            return 1;
        }
        return Integer.signum(result);
    }
}

