/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] reverse(@Nonnull T[] elementsArray) {
        T[] elements = Objects.requireNonNull(elementsArray);
        T[] results = Arrays.copyOf(elements, elements.length);
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    public static int[] reverse(@Nonnull int[] elementsArray) {
        int[] elements = Objects.requireNonNull(elementsArray);
        int[] results = new int[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    public static long[] reverse(@Nonnull long[] elementsArray) {
        long[] elements = Objects.requireNonNull(elementsArray);
        long[] results = new long[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    public static double[] reverse(@Nonnull double[] elementsArray) {
        double[] elements = Objects.requireNonNull(elementsArray);
        double[] results = new double[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    public static float[] reverse(@Nonnull float[] elementsArray) {
        float[] elements = Objects.requireNonNull(elementsArray);
        float[] results = new float[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    public static boolean[] reverse(@Nonnull boolean[] elementsArray) {
        boolean[] elements = Objects.requireNonNull(elementsArray);
        boolean[] results = new boolean[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = elements[elements.length - i - 1];
        }
        return results;
    }

    @Nonnull
    public static String[] appendArray(@Nonnull String[] first, @Nonnull String[] second) {
        int length = first.length + second.length;
        String[] result = new String[length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @Nonnull
    public static int[] appendArray(@Nonnull int[] first, @Nonnull int[] second) {
        int length = first.length + second.length;
        int[] result = new int[length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

