/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Color;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.util.Bundle;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorUtil {
    public static final String ColorTrack = "track";
    public static final String ColorBlack = "black";
    public static final String ColorDarkGray = "darkGray";
    public static final String ColorGray = "gray";
    public static final String ColorLightGray = "lightGray";
    public static final String ColorWhite = "white";
    public static final String ColorRed = "red";
    public static final String ColorPink = "pink";
    public static final String ColorOrange = "orange";
    public static final String ColorYellow = "yellow";
    public static final String ColorGreen = "green";
    public static final String ColorBlue = "blue";
    public static final String ColorMagenta = "magenta";
    public static final String ColorCyan = "cyan";
    public static final String ColorClear = "clear";
    public static final String ColorBrown = "brown";
    public static final Color clear;
    public static final Color CLEAR;
    public static final Color BROWN;
    private static final Logger log;

    @Nonnull
    public static String colorToString(@CheckForNull Color color) {
        if (color == null) {
            return ColorTrack;
        }
        String colorName = ColorUtil.colorToName(color);
        if (colorName != null) {
            return colorName;
        }
        log.error("unknown color sent to colorToString");
        return ColorBlack;
    }

    @CheckForNull
    public static String colorToColorName(@CheckForNull Color color) {
        if (color == null) {
            return null;
        }
        String colorName = ColorUtil.colorToName(color);
        if (colorName != null) {
            return colorName;
        }
        return ColorUtil.colorToHexString(color);
    }

    @CheckForNull
    public static String colorToLocalizedName(@CheckForNull Color color) {
        if (color == null) {
            return null;
        }
        Object colorName = ColorUtil.colorToName(color);
        if (colorName != null) {
            colorName = Character.toUpperCase(((String)colorName).charAt(0)) + ((String)colorName).substring(1);
            return Bundle.getMessage((String)colorName);
        }
        return ColorUtil.colorToHexString(color);
    }

    public static Color stringToColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException nfe) {
            switch (string) {
                case "black": {
                    return Color.black;
                }
                case "darkGray": {
                    return Color.darkGray;
                }
                case "gray": {
                    return Color.gray;
                }
                case "lightGray": {
                    return Color.lightGray;
                }
                case "white": {
                    return Color.white;
                }
                case "red": {
                    return Color.red;
                }
                case "pink": {
                    return Color.pink;
                }
                case "orange": {
                    return Color.orange;
                }
                case "yellow": {
                    return Color.yellow;
                }
                case "green": {
                    return Color.green;
                }
                case "blue": {
                    return Color.blue;
                }
                case "magenta": {
                    return Color.magenta;
                }
                case "cyan": {
                    return Color.cyan;
                }
                case "brown": {
                    return BROWN;
                }
                case "track": {
                    return null;
                }
            }
            if (string.equals(Bundle.getMessage("Black"))) {
                return Color.black;
            }
            if (string.equals(Bundle.getMessage("DarkGray"))) {
                return Color.darkGray;
            }
            if (string.equals(Bundle.getMessage("Gray"))) {
                return Color.gray;
            }
            if (string.equals(Bundle.getMessage("LightGray"))) {
                return Color.lightGray;
            }
            if (string.equals(Bundle.getMessage("White"))) {
                return Color.white;
            }
            if (string.equals(Bundle.getMessage("Red"))) {
                return Color.red;
            }
            if (string.equals(Bundle.getMessage("Pink"))) {
                return Color.pink;
            }
            if (string.equals(Bundle.getMessage("Yellow"))) {
                return Color.yellow;
            }
            if (string.equals(Bundle.getMessage("Green"))) {
                return Color.green;
            }
            if (string.equals(Bundle.getMessage("Orange"))) {
                return Color.orange;
            }
            if (string.equals(Bundle.getMessage("Blue"))) {
                return Color.blue;
            }
            if (string.equals(Bundle.getMessage("Magenta"))) {
                return Color.magenta;
            }
            if (string.equals(Bundle.getMessage("Cyan"))) {
                return Color.cyan;
            }
            if (string.equals(Bundle.getMessage("ColorClear"))) {
                return clear;
            }
            if (string.equals(Bundle.getMessage("None"))) {
                return null;
            }
            log.error("unknown color text '{}' sent to stringToColor", (Object)string);
            throw new IllegalArgumentException("unknown color text '" + string + "'");
        }
    }

    @CheckForNull
    public static String colorToHexString(@CheckForNull Color color) {
        if (color == null) {
            return null;
        }
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    @CheckForNull
    private static String colorToName(@CheckForNull Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.black)) {
            return ColorBlack;
        }
        if (color.equals(Color.darkGray)) {
            return ColorDarkGray;
        }
        if (color.equals(Color.gray)) {
            return ColorGray;
        }
        if (color.equals(Color.lightGray)) {
            return ColorLightGray;
        }
        if (color.equals(Color.white)) {
            return ColorWhite;
        }
        if (color.equals(Color.red)) {
            return ColorRed;
        }
        if (color.equals(Color.pink)) {
            return ColorPink;
        }
        if (color.equals(Color.orange)) {
            return ColorOrange;
        }
        if (color.equals(Color.yellow)) {
            return ColorYellow;
        }
        if (color.equals(Color.green)) {
            return ColorGreen;
        }
        if (color.equals(Color.blue)) {
            return ColorBlue;
        }
        if (color.equals(Color.magenta)) {
            return ColorMagenta;
        }
        if (color.equals(Color.cyan)) {
            return ColorCyan;
        }
        if (color.equals(BROWN)) {
            return ColorBrown;
        }
        return null;
    }

    public static Color contrast(@Nonnull Color color) {
        int blue;
        int green;
        int red = color.getRed();
        int average = (red + (green = color.getGreen()) + (blue = color.getBlue())) / 3;
        return average >= 128 ? Color.BLACK : Color.WHITE;
    }

    @CheckReturnValue
    public static Color lerp(@Nonnull Color colorA, @Nonnull Color colorB, double t) {
        return new Color(MathUtil.lerp(colorA.getRed(), colorB.getRed(), t), MathUtil.lerp(colorA.getGreen(), colorB.getGreen(), t), MathUtil.lerp(colorA.getBlue(), colorB.getBlue(), t), MathUtil.lerp(colorA.getAlpha(), colorB.getAlpha(), t));
    }

    @CheckReturnValue
    public static Color setAlpha(@Nonnull Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @CheckReturnValue
    public static Color setAlpha(@Nonnull Color color, double alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * alpha));
    }

    static {
        CLEAR = clear = ColorUtil.setAlpha(Color.BLACK, 0);
        BROWN = new Color(102, 51, 0);
        log = LoggerFactory.getLogger(ColorUtil.class);
    }
}

