/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import jmri.util.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareUtil.class);

    public static boolean compare(CompareType type, CompareOperation oper, Object value1, Object value2, boolean caseInsensitive) {
        switch (type) {
            case NumberOrString: {
                return CompareUtil.compareNumber(false, oper, value1, value2, caseInsensitive);
            }
            case String: {
                return CompareUtil.compareString(oper, value1, value2, caseInsensitive);
            }
            case Number: {
                return CompareUtil.compareNumber(true, oper, value1, value2, caseInsensitive);
            }
        }
        throw new IllegalArgumentException("type has unknown value: " + type.name());
    }

    public static boolean compareString(CompareOperation oper, Object value1, Object value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        String s1 = value1.toString().trim();
        String s2 = value2.toString().trim();
        int compare = caseInsensitive ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
        switch (oper) {
            case LessThan: {
                if (compare >= 0) break;
                return true;
            }
            case LessThanOrEqual: {
                if (compare > 0) break;
                return true;
            }
            case Equal: {
                if (compare != 0) break;
                return true;
            }
            case NotEqual: {
                if (compare == 0) break;
                return true;
            }
            case GreaterThanOrEqual: {
                if (compare < 0) break;
                return true;
            }
            case GreaterThan: {
                if (compare <= 0) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("oper has unknown value: " + oper.name());
            }
        }
        return false;
    }

    public static boolean compareNumber(boolean requireNumber, CompareOperation oper, Object value1, Object value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        String s1 = value1.toString().trim();
        String s2 = value2.toString().trim();
        try {
            double n1 = value1 instanceof Number ? ((Number)value1).doubleValue() : Double.parseDouble(s1);
            try {
                double n2 = value2 instanceof Number ? ((Number)value2).doubleValue() : Double.parseDouble(s2);
                log.debug("Compare numbers: n1= {} to n2= {}", (Object)n1, (Object)n2);
                switch (oper) {
                    case LessThan: {
                        return n1 < n2;
                    }
                    case LessThanOrEqual: {
                        return n1 <= n2;
                    }
                    case Equal: {
                        return n1 == n2;
                    }
                    case NotEqual: {
                        return n1 != n2;
                    }
                    case GreaterThanOrEqual: {
                        return n1 >= n2;
                    }
                    case GreaterThan: {
                        return n1 > n2;
                    }
                }
                throw new IllegalArgumentException("oper has unknown value: " + oper.name());
            }
            catch (NumberFormatException nfe) {
                if (requireNumber) {
                    throw new IllegalArgumentException(Bundle.getMessage("CompareUtil_Error_Value1IsNotANumber", value1));
                }
                return oper == CompareOperation.NotEqual;
            }
        }
        catch (NumberFormatException nfe) {
            try {
                Integer.parseInt(s2);
                if (requireNumber) {
                    throw new IllegalArgumentException(Bundle.getMessage("CompareUtil_Error_Value1IsNotANumber", value1));
                }
                return oper == CompareOperation.NotEqual;
            }
            catch (NumberFormatException ex) {
                if (requireNumber) {
                    throw new IllegalArgumentException(Bundle.getMessage("CompareUtil_Error_NeitherValueIsNumber", value1, value2));
                }
                return CompareUtil.compareString(oper, value1, value2, caseInsensitive);
            }
        }
    }

    public static enum CompareOperation {
        LessThan(Bundle.getMessage("CompareUtil_CompareOperation_LessThan")),
        LessThanOrEqual(Bundle.getMessage("CompareUtil_CompareOperation_LessThanOrEqual")),
        Equal(Bundle.getMessage("CompareUtil_CompareOperation_Equal")),
        GreaterThanOrEqual(Bundle.getMessage("CompareUtil_CompareOperation_GreaterThanOrEqual")),
        GreaterThan(Bundle.getMessage("CompareUtil_CompareOperation_GreaterThan")),
        NotEqual(Bundle.getMessage("CompareUtil_CompareOperation_NotEqual"));

        private final String _text;

        private CompareOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum CompareType {
        NumberOrString(Bundle.getMessage("CompareUtil_CompareType_NumberOrString")),
        String(Bundle.getMessage("CompareUtil_CompareType_String")),
        Number(Bundle.getMessage("CompareUtil_CompareType_Number"));

        private final String _text;

        private CompareType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

