/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.time.Duration;
import java.util.GregorianCalendar;

public class DateUtil {
    private DateUtil() {
    }

    public static GregorianCalendar calFromJulianDate(long julianDay) {
        long l = julianDay + 68569L;
        long n = 4L * l / 146097L;
        long year = 4000L * ((l -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
        l = l - 1461L * year / 4L + 31L;
        long month = 80L * l / 2447L;
        long day = l - 2447L * month / 80L - 31L;
        l = month / 11L;
        month = month + 2L - 12L * l;
        year = 100L * (n - 49L) + year + l;
        return new GregorianCalendar((int)year, (int)month, (int)day, 0, 0);
    }

    public static long julianDayFromCalendar(GregorianCalendar cal) {
        int i = cal.get(1);
        int j = cal.get(2) + 1;
        int k = cal.get(5);
        return k - 32075 + 1461 * (i + 4800 + (j - 14) / 12) / 4 + 367 * (j - 2 - (j - 14) / 12 * 12) / 12 - 3 * ((i + 4900 + (j - 14) / 12) / 100) / 4;
    }

    public static String userDurationFromSeconds(int seconds) {
        String minus = seconds < 0 ? "- " : "";
        Duration duration = Duration.ofSeconds(Math.abs(seconds));
        long days = duration.toDays();
        long hours = duration.minusDays(days).toHours();
        long mins = duration.minusDays(days).minusHours(hours).toMinutes();
        long secs = duration.minusDays(days).minusHours(hours).minusMinutes(mins).toSeconds();
        if (days == 0L) {
            return minus + String.format("%02d:%02d:%02d", hours, mins, secs);
        }
        return minus + String.format("%d %02d:%02d:%02d", days, hours, mins, secs);
    }
}

