/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDTableExportHandler
extends TransferHandler {
    private static final Logger log = LoggerFactory.getLogger(DnDTableExportHandler.class);

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        Object obj;
        if (!(c instanceof JTable)) {
            return null;
        }
        JTable table = (JTable)c;
        int col = table.getSelectedColumn();
        int row = table.getSelectedRow();
        if (col < 0 || row < 0) {
            return null;
        }
        row = table.convertRowIndexToModel(row);
        col = table.convertColumnIndexToModel(col);
        if (log.isDebugEnabled()) {
            log.debug("TransferHandler.createTransferable: from ({}, {}) for \"{}\"", new Object[]{row, col, table.getModel().getValueAt(row, col)});
        }
        if ((obj = table.getModel().getValueAt(row, col)) instanceof String) {
            return new StringSelection((String)obj);
        }
        if (obj != null) {
            return new StringSelection(obj.getClass().getName());
        }
        return null;
    }

    @Override
    public void exportDone(JComponent c, Transferable t, int action) {
        if (log.isDebugEnabled()) {
            log.debug("TransferHandler.exportDone ");
        }
    }
}

