/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.util.FileUtil;
import jmri.util.SystemType;

public class EarlyInitializationPreferences {
    private static final String FILENAME = FileUtil.getExternalFilename("settings:JMRI_InitPreferences.properties");
    private static final EarlyInitializationPreferences INSTANCE = new EarlyInitializationPreferences();
    private final Properties preferences = new Properties();
    private final List<String> startupPrefs = new ArrayList<String>();

    private EarlyInitializationPreferences() {
    }

    public static EarlyInitializationPreferences getInstance() {
        return INSTANCE;
    }

    public String getPreference(String pref) {
        return this.preferences.getProperty(pref);
    }

    public void setPreference(String pref, String value) {
        this.preferences.setProperty(pref, value);
        this.store();
    }

    public boolean getGUIForce100percentScaling() {
        String value = this.getPreference("sun.java2d.uiScale");
        if (value == null) {
            return false;
        }
        try {
            return Integer.parseInt(value) == 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setGUIForce100percentScaling(boolean value) {
        this.setPreference("sun.java2d.uiScale", value ? "1" : "0");
    }

    public void loadAndSetPreferences() {
        this.load();
        for (String pref : this.preferences.stringPropertyNames()) {
            System.setProperty(pref, this.preferences.getProperty(pref));
            this.startupPrefs.add(pref + ": " + this.preferences.getProperty(pref));
        }
    }

    public List<String> getStartupPreferences() {
        return this.startupPrefs;
    }

    private boolean store() {
        block8: {
            boolean bl;
            FileOutputStream output = new FileOutputStream(FILENAME);
            try {
                this.preferences.store(output, null);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    System.err.println("Could not store to " + FILENAME + ", Normal if JMRI has not been started before.");
                    break block8;
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
            ((OutputStream)output).close();
            return bl;
        }
        return false;
    }

    private void load() {
        try (FileInputStream input = new FileInputStream(FILENAME);){
            this.preferences.load(input);
        }
        catch (IOException ex) {
            this.setupNewPreferences();
        }
    }

    private void setupNewPreferences() {
        boolean restartIsNeeded = false;
        if (SystemType.isWindows()) {
            int uiScale = 1;
            if (!GraphicsEnvironment.isHeadless()) {
                try {
                    restartIsNeeded = true;
                    GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    AffineTransform transform = gc.getDefaultTransform();
                    double scaleX = transform.getScaleX();
                    double scaleY = transform.getScaleY();
                    System.err.format("ScaleX: %1.2f%n", scaleX);
                    System.err.format("ScaleY: %1.2f%n", scaleY);
                    if (scaleX >= 1.3 || scaleY >= 1.3) {
                        uiScale = 0;
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace(System.err);
                }
            }
            this.preferences.setProperty("sun.java2d.uiScale", Integer.toString(uiScale));
        }
        if (this.store() && restartIsNeeded) {
            InstanceManager.getDefault(ShutDownManager.class).restart();
        }
    }
}

