/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Button;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.util.Bundle;
import jmri.util.FileUtil;
import jmri.util.HelpUtilPreferences;
import jmri.util.SystemType;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpUtil {
    private static final Logger log = LoggerFactory.getLogger(HelpUtil.class);

    private HelpUtil() {
    }

    public static JMenu helpMenu(JMenuBar menuBar, String ref, boolean direct) {
        JMenu helpMenu = HelpUtil.makeHelpMenu(ref, direct);
        if (menuBar != null) {
            menuBar.add(helpMenu);
        }
        return helpMenu;
    }

    public static JMenu makeHelpMenu(String ref, boolean direct) {
        JMenu helpMenu = new JMenu(Bundle.getMessage("ButtonHelp"));
        helpMenu.add(HelpUtil.makeHelpMenuItem(ref));
        if (direct) {
            ServiceLoader<MenuProvider> providers = ServiceLoader.load(MenuProvider.class);
            providers.forEach(provider -> provider.getHelpMenuItems().forEach(i -> {
                if (i != null) {
                    helpMenu.add((JMenuItem)i);
                } else {
                    helpMenu.addSeparator();
                }
            }));
        }
        return helpMenu;
    }

    public static JMenuItem makeHelpMenuItem(String ref) {
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("MenuItemWindowHelp"));
        menuItem.addActionListener(ignore -> HelpUtil.displayHelpRef(ref));
        return menuItem;
    }

    public static void addHelpToComponent(Component component, String ref) {
        HelpUtil.enableHelpOnButton(component, ref);
    }

    public static void enableHelpOnButton(Component comp, String id) {
        if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).addActionListener(ignore -> HelpUtil.displayHelpRef(id));
        } else if (comp instanceof Button) {
            ((Button)comp).addActionListener(ignore -> HelpUtil.displayHelpRef(id));
        } else {
            throw new IllegalArgumentException("comp is not a javax.swing.AbstractButton or a java.awt.Button");
        }
    }

    public static void displayHelpRef(String ref) {
        String fileName;
        String url;
        Object tempFile;
        log.debug("displayHelpRef: {}", (Object)ref);
        boolean isPluginHelp = ref.startsWith("plugin:");
        boolean isFrench = "fr".equals(InstanceManager.getDefault(GuiLafPreferencesManager.class).getLocale().getLanguage());
        String localeStr = isFrench && !isPluginHelp ? "fr" : "en";
        HelpUtilPreferences preferences = InstanceManager.getDefault(HelpUtilPreferences.class);
        if (isPluginHelp) {
            tempFile = "plugin";
            ref = ref.substring("plugin:".length());
        } else {
            tempFile = "help/" + localeStr;
        }
        tempFile = (String)tempFile + "/" + ref.replace(".", "/");
        String[] fileParts = ((String)tempFile).split("_", 2);
        String file = fileParts[0] + ".shtml";
        if (fileParts.length > 1) {
            file = file + "#" + fileParts[1];
        }
        boolean webError = false;
        if (preferences.getOpenHelpOnline() && !isPluginHelp) {
            url = "https://www.jmri.org/" + file;
            if (HelpUtil.showWebPage(ref, url)) {
                return;
            }
            webError = true;
        }
        if (preferences.getOpenHelpOnJMRIWebServer() || isPluginHelp) {
            WebServerPreferences webServerPreferences = InstanceManager.getDefault(WebServerPreferences.class);
            String port = Integer.toString(webServerPreferences.getPort());
            url = "http://localhost:" + port + "/" + file;
            log.debug("displayHelpRef: url: {}", (Object)url);
            if (HelpUtil.showWebPage(ref, url)) {
                return;
            }
            webError = true;
        }
        if (webError) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("HelpWeb_ServerError"), Bundle.getMessage("HelpWeb_Title"), 0);
            if (isPluginHelp) {
                return;
            }
        }
        try {
            fileName = HelpUtil.createStubFile(ref, localeStr);
        }
        catch (IOException iox) {
            log.error("Unable to create the stub file for \"{}\" ", (Object)ref);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("HelpError_StubFile", ref), Bundle.getMessage("HelpStub_Title"), 0);
            return;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            log.error("The help reference \"{}\" is not found. File is not found: {}", (Object)ref, (Object)fileName);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("HelpError_ReferenceNotFound", ref), Bundle.getMessage("HelpError_Title"), 0);
            return;
        }
        if (SystemType.isWindows()) {
            try {
                HelpUtil.openWindowsFile(f);
            }
            catch (JmriException e) {
                log.error("unable to show help page {} in Windows due to:", (Object)ref, (Object)e);
            }
            return;
        }
        url = "file://" + fileName;
        HelpUtil.showWebPage(ref, url);
    }

    public static String createStubFile(String helpKey, String locale) throws IOException {
        String stubLocation = FileUtil.getHomePath() + "jmrihelp/";
        FileUtil.createDirectory(stubLocation);
        log.debug("---- stub location: {}", (Object)stubLocation);
        String htmlLocation = FileUtil.getProgramPath() + "help/" + locale + "/local/";
        log.debug("---- html location: {}", (Object)htmlLocation);
        String template = FileUtil.readFile(new File(htmlLocation + "stub_template.html"));
        Object expandedHelpKey = helpKey.replace(".", "/");
        int pos = ((String)expandedHelpKey).indexOf(95);
        expandedHelpKey = pos == -1 ? (String)expandedHelpKey + ".shtml" : ((String)expandedHelpKey).substring(0, pos) + ".shtml#" + ((String)expandedHelpKey).substring(pos + 1);
        String contents = template.replace("<!--HELP_KEY-->", htmlLocation + "index.html#" + helpKey);
        contents = contents.replace("<!--URL_HELP_KEY-->", (CharSequence)expandedHelpKey);
        PrintWriter printWriter = new PrintWriter(stubLocation + "stub.html");
        printWriter.print(contents);
        printWriter.close();
        return stubLocation + "stub.html";
    }

    public static void openWindowsFile(File file) throws JmriException {
        try {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                throw new JmriException("Failed to connect to browser. java.awt.Desktop in Windows doesn't support Action.OPEN");
            }
            Desktop.getDesktop().open(file);
        }
        catch (IOException ex) {
            throw new JmriException(String.format("Failed to connect to browser. Error loading help file %s", file.getName()), ex);
        }
    }

    public static boolean showWebPage(String ref, String url) {
        boolean result = false;
        try {
            HelpUtil.openWebPage(url);
            result = true;
        }
        catch (JmriException e) {
            log.warn("unable to show help page {} due to:", (Object)ref, (Object)e);
        }
        return result;
    }

    public static void openWebPage(String url) throws JmriException {
        try {
            URI uri = new URI(url);
            if (!url.toLowerCase().startsWith("file://")) {
                HttpURLConnection request = (HttpURLConnection)uri.toURL().openConnection();
                request.setRequestMethod("GET");
                request.connect();
                if (request.getResponseCode() != 200) {
                    throw new JmriException(String.format("Failed to connect to web page: %d, %s", request.getResponseCode(), request.getResponseMessage()));
                }
            }
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new JmriException("Failed to connect to web page. java.awt.Desktop doesn't suppport Action.BROWSE");
            }
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new JmriException(String.format("Failed to connect to web page. Exception thrown: %s", e.getMessage()), e);
        }
    }

    public static Action getHelpAction(String name, Icon icon, final String id) {
        return new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpUtil.displayHelpRef(id);
            }
        };
    }

    public static interface MenuProvider {
        @Nonnull
        public List<JMenuItem> getHelpMenuItems();
    }
}

