/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.prefs.Preferences;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PreferencesBean;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;

public final class HelpUtilPreferences
extends PreferencesBean
implements InstanceManagerAutoDefault {
    public static final String OPEN_HELP_ONLINE = "openHelpOnline";
    public static final String OPEN_HELP_ON_FILE = "openHelpOnFile";
    public static final String OPEN_HELP_ON_JMRI_WEB_SERVER = "openHelpOnJMRIWebServer";
    private boolean _openHelpOnline = false;
    private boolean _openHelpOnFile = true;
    private boolean _openHelpOnJMRIWebServer = false;

    public HelpUtilPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._openHelpOnline = sharedPreferences.getBoolean(OPEN_HELP_ONLINE, this._openHelpOnline);
        this._openHelpOnFile = sharedPreferences.getBoolean(OPEN_HELP_ON_FILE, this._openHelpOnFile);
        this._openHelpOnJMRIWebServer = sharedPreferences.getBoolean(OPEN_HELP_ON_JMRI_WEB_SERVER, this._openHelpOnJMRIWebServer);
        this.setIsDirty(false);
    }

    public boolean compareValuesDifferent(HelpUtilPreferences prefs) {
        if (this.getOpenHelpOnline() != prefs.getOpenHelpOnline()) {
            return true;
        }
        if (this.getOpenHelpOnFile() != prefs.getOpenHelpOnFile()) {
            return true;
        }
        return this.getOpenHelpOnJMRIWebServer() != prefs.getOpenHelpOnJMRIWebServer();
    }

    public void apply(HelpUtilPreferences prefs) {
        this.setOpenHelpOnline(prefs.getOpenHelpOnline());
        this.setOpenHelpOnFile(prefs.getOpenHelpOnFile());
        this.setOpenHelpOnJMRIWebServer(prefs.getOpenHelpOnJMRIWebServer());
    }

    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean(OPEN_HELP_ONLINE, this.getOpenHelpOnline());
        sharedPreferences.putBoolean(OPEN_HELP_ON_FILE, this.getOpenHelpOnFile());
        sharedPreferences.putBoolean(OPEN_HELP_ON_JMRI_WEB_SERVER, this.getOpenHelpOnJMRIWebServer());
        this.setIsDirty(false);
    }

    public void setOpenHelpOnline(boolean value) {
        this._openHelpOnline = value;
        this.setIsDirty(true);
    }

    public boolean getOpenHelpOnline() {
        return this._openHelpOnline;
    }

    public void setOpenHelpOnFile(boolean value) {
        this._openHelpOnFile = value;
        this.setIsDirty(true);
    }

    public boolean getOpenHelpOnFile() {
        return this._openHelpOnFile;
    }

    public void setOpenHelpOnJMRIWebServer(boolean value) {
        this._openHelpOnJMRIWebServer = value;
        this.setIsDirty(true);
    }

    public boolean getOpenHelpOnJMRIWebServer() {
        return this._openHelpOnJMRIWebServer;
    }
}

