/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class JTreeWithPopup
extends JTree
implements ActionListener {
    JPopupMenu popup = new JPopupMenu();
    JMenuItem mi = new JMenuItem("Insert a children");

    JTreeWithPopup(DefaultMutableTreeNode dmtn) {
        super(dmtn);
        this.mi.addActionListener(this);
        this.mi.setActionCommand("insert");
        this.popup.add(this.mi);
        this.mi = new JMenuItem("Remove this node");
        this.mi.addActionListener(this);
        this.mi.setActionCommand("remove");
        this.popup.add(this.mi);
        this.popup.setOpaque(true);
        this.popup.setLightWeightPopupEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTreeWithPopup.this.popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        DefaultMutableTreeNode node;
        TreePath path = this.getSelectionPath();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (ae.getActionCommand().equals("insert")) {
            node = new DefaultMutableTreeNode("children");
            dmtn.add(node);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(dmtn);
        }
        if (ae.getActionCommand().equals("remove")) {
            node = (DefaultMutableTreeNode)dmtn.getParent();
            int nodeIndex = node.getIndex(dmtn);
            dmtn.removeAllChildren();
            node.remove(nodeIndex);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(dmtn);
        }
    }
}

