/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriInsets {
    private static final String DESKTOP_ENVIRONMENTS = "kdesktop|gnome-panel|xfce|darwin|icewm";
    private static final String GNOME_CONFIG = "%gconf.xml";
    private static final String GNOME_PANEL = "_panel_screen";
    private static final String GNOME_ROOT = System.getProperty("user.home") + "/.gconf/apps/panel/toplevels/";
    private static final String KDE_CONFIG = System.getProperty("user.home") + "/.kde/share/config/kickerrc";
    private static final String OS_NAME = SystemType.getOSName();
    private static int linuxWM = -2;
    private static final Logger log = LoggerFactory.getLogger(JmriInsets.class);

    public static Insets getInsets() {
        if (linuxWM == -2) {
            linuxWM = JmriInsets.getLinuxWindowManager();
        }
        switch (linuxWM) {
            case 0: {
                return JmriInsets.getKDEInsets();
            }
            case 1: {
                return JmriInsets.getGnomeInsets();
            }
            case 2: {
                return JmriInsets.getXfceInsets();
            }
            case 3: {
                return JmriInsets.getDarwinInsets();
            }
            case 4: {
                return JmriInsets.getIcewmInsets();
            }
        }
        return JmriInsets.getDefaultInsets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getLinuxWindowManager() {
        if (SystemType.isWindows()) return -1;
        if (OS_NAME.toLowerCase().startsWith("mac")) return -1;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"ps", "ax"});
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                List<String> desktopList = Arrays.asList(DESKTOP_ENVIRONMENTS.split("\\|"));
                String line = r.readLine();
                while (line != null) {
                    for (int i = 0; i < desktopList.size(); ++i) {
                        String s = desktopList.get(i);
                        if (!line.contains(s) || line.contains("grep")) continue;
                        int n = desktopList.indexOf(s);
                        return n;
                    }
                    line = r.readLine();
                }
                return -1;
            }
            catch (IOException e1) {
                log.error("error reading file", (Throwable)e1);
                throw e1;
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException e2) {
                    log.error("Exception closing file", (Throwable)e2);
                }
            }
        }
        catch (IOException e) {
            log.error("IO Exception");
        }
        return -1;
    }

    private static Insets getKDEInsets() {
        int[] sizes = new int[]{24, 30, 46, 58, 0};
        int[] i = new int[]{0, 0, 0, 0, 0};
        int iniCustomSize = JmriInsets.getKdeINI("General", "CustomSize");
        int iniSize = JmriInsets.getKdeINI("General", "Size");
        int iniPosition = JmriInsets.getKdeINI("General", "Position");
        int position = iniPosition == -1 ? 3 : iniPosition;
        int size = iniCustomSize == -1 || iniSize != 4 ? iniSize : iniCustomSize;
        i[position] = size = size < 24 ? sizes[size] : size;
        return new Insets(i[2], i[0], i[3], i[1]);
    }

    private static Insets getGnomeInsets() {
        File gnomeRoot = new File(GNOME_ROOT);
        int n = 0;
        int s = 0;
        int e = 0;
        int w = 0;
        File[] files = gnomeRoot.listFiles();
        if (files != null) {
            for (File f : files) {
                int val;
                String folder = f.getName();
                if (!f.isDirectory() || !folder.contains(GNOME_PANEL) || (val = JmriInsets.getGnomeXML(new File(GNOME_ROOT + "/" + folder + "/%gconf.xml"))) == -1) continue;
                if (folder.startsWith("top_panel_screen")) {
                    n = Math.max(val, n);
                    continue;
                }
                if (folder.startsWith("bottom_panel_screen")) {
                    s = Math.max(val, s);
                    continue;
                }
                if (folder.startsWith("right_panel_screen")) {
                    e = Math.max(val, e);
                    continue;
                }
                if (!folder.startsWith("left_panel_screen")) continue;
                w = Math.max(val, w);
            }
        }
        return new Insets(n, w, s, e);
    }

    private static Insets getXfceInsets() {
        return JmriInsets.getDefaultInsets(false);
    }

    private static Insets getDarwinInsets() {
        return JmriInsets.getDefaultInsets(false);
    }

    private static Insets getIcewmInsets() {
        return new Insets(0, 0, 25, 0);
    }

    private static Insets getDefaultInsets() {
        if (!OS_NAME.toLowerCase().startsWith("windows") && !OS_NAME.toLowerCase().startsWith("mac")) {
            return JmriInsets.getDefaultInsets(false);
        }
        return JmriInsets.getDefaultInsets(true);
    }

    private static Insets getDefaultInsets(boolean logOS) {
        if (logOS) {
            log.trace("Trying default insets for {}", (Object)OS_NAME);
        }
        try {
            GraphicsDevice[] gs;
            GraphicsDevice[] graphicsDeviceArray = gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = graphicsDeviceArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                GraphicsDevice g = graphicsDeviceArray[i];
                GraphicsConfiguration[] gc = g.getConfigurations();
                GraphicsConfiguration[] graphicsConfigurationArray = gc;
                int n3 = graphicsConfigurationArray.length;
                if (n2 >= n3) continue;
                GraphicsConfiguration element = graphicsConfigurationArray[n2];
                return Toolkit.getDefaultToolkit().getScreenInsets(element);
            }
        }
        catch (HeadlessException h) {
            log.debug("Warning: Headless error - no GUI available");
        }
        return new Insets(0, 0, 0, 0);
    }

    private static int getGnomeXML(File xmlFile) {
        try {
            String temp;
            boolean found = false;
            try (FileReader reader = new FileReader(xmlFile);
                 BufferedReader buffer = new BufferedReader(reader);){
                temp = buffer.readLine();
                while (temp != null) {
                    if (temp.contains("<entry name=\"size\"")) {
                        found = true;
                        break;
                    }
                    temp = buffer.readLine();
                }
            }
            if (temp == null) {
                return -1;
            }
            if (found) {
                temp = temp.substring(temp.indexOf("value=\"") + 7);
                return Integer.parseInt(temp.substring(0, temp.indexOf(34)));
            }
        }
        catch (IOException e) {
            log.error("Error parsing Gnome XML: {}", (Object)e.getMessage());
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getKdeINI(String category, String component) {
        try {
            File f = new File(KDE_CONFIG);
            if (!f.exists()) return -1;
            if (category == null) return -1;
            if (component == null) {
                return -1;
            }
            boolean found = false;
            String value = null;
            FileReader reader = new FileReader(f);
            BufferedReader buffer = new BufferedReader(reader);
            try {
                String temp = buffer.readLine();
                while (temp != null) {
                    if (temp.trim().equals("[" + category + "]")) {
                        temp = buffer.readLine();
                        while (temp != null) {
                            if (temp.trim().startsWith("[")) {
                                int n = -1;
                                return n;
                            }
                            if (temp.startsWith(component + "=")) {
                                value = temp.substring(component.length() + 1);
                                found = true;
                                break;
                            }
                            temp = buffer.readLine();
                        }
                    }
                    if (!found) {
                        temp = buffer.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e1) {
                log.error("error reading file", (Throwable)e1);
                throw e1;
            }
            finally {
                try {
                    buffer.close();
                }
                catch (IOException e2) {
                    log.error("Exception closing file", (Throwable)e2);
                }
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    log.error("Exception closing file", (Throwable)e2);
                }
            }
            if (!found) return -1;
            return Integer.parseInt(value);
        }
        catch (IOException e) {
            log.error("Error parsing KDI_CONFIG: {}", (Object)e.getMessage());
        }
        return -1;
    }
}

