/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import jmri.util.FileUtil;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JmriLocalEntityResolver
implements EntityResolver {
    private static final Logger log = LoggerFactory.getLogger(JmriLocalEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        log.trace("-- got entity request {}", (Object)systemId);
        try {
            URI uri = new URI(systemId);
            log.trace("systemId: {}", (Object)systemId);
            String scheme = uri.getScheme();
            String source = uri.getSchemeSpecificPart();
            Object path = uri.getPath();
            log.trace("scheme: {}", (Object)scheme);
            log.trace("source: {}", (Object)source);
            log.trace("path: {}", path);
            if (scheme.equals("http")) {
                if (systemId.equals("http://www.w3.org/2001/XInclude.xsd")) {
                    path = "/xml/schema/xinclude.xsd";
                }
                String filename = ((String)path).substring(1).trim();
                log.trace("http finds filename: {}", (Object)filename);
                InputStream stream = FileUtil.findInputStream(filename);
                if (stream != null) {
                    return new InputSource(stream);
                }
                log.debug("did not find local type 3 DTD file: {}", (Object)filename);
                return null;
            }
            if (path != null && ((String)path).startsWith("../DTD")) {
                String filename = "xml" + File.separator + "DTD" + File.separator + (String)path;
                log.trace("starts with ../DTD finds filename: {}", (Object)filename);
                InputStream stream = FileUtil.findInputStream(filename);
                if (stream != null) {
                    return new InputSource(stream);
                }
                log.error("did not find type 1 DTD file: {}", (Object)filename);
                return null;
            }
            if (path != null && !((String)path).contains("/")) {
                String filename = "xml" + File.separator + "DTD" + File.separator + (String)path;
                log.trace("doesn't contain / finds filename: {}", (Object)filename);
                InputStream stream = FileUtil.findInputStream(filename);
                if (stream != null) {
                    return new InputSource(stream);
                }
                log.error("did not find type 2 entity file: {}", (Object)filename);
                return null;
            }
            if (scheme.equals("file")) {
                if (path != null) {
                    log.trace("scheme file finds path: {}", path);
                    InputStream stream = FileUtil.findInputStream((String)path);
                    if (stream != null) {
                        log.trace("file exists, used");
                        return new InputSource(stream);
                    }
                    String realSeparator = File.separator;
                    if (SystemType.isWindows()) {
                        int forIndex = ((String)path).indexOf("/");
                        int backIndex = ((String)path).indexOf("\\");
                        if (forIndex >= 0 && backIndex < 0) {
                            realSeparator = "/";
                        } else if (forIndex < 0 && backIndex >= 0) {
                            realSeparator = "\\";
                        } else if (forIndex > 0 && backIndex >= forIndex) {
                            realSeparator = "\\";
                        } else if (backIndex > 0 && forIndex >= backIndex) {
                            realSeparator = "/";
                        }
                        log.trace(" forIndex {} backIndex {}", (Object)forIndex, (Object)backIndex);
                    }
                    log.trace("File.separator {} realSeparator {}", (Object)File.separator, (Object)realSeparator);
                    if (((String)path).lastIndexOf(realSeparator + "DTD" + realSeparator) >= 0) {
                        log.trace("file not exist, DTD in name, insert xml directory");
                        String modifiedPath = realSeparator + "xml" + ((String)path).substring(((String)path).lastIndexOf(realSeparator + "DTD" + realSeparator), ((String)path).length()).trim();
                        path = modifiedPath;
                    } else {
                        log.trace("file not exist, no DTD, insert xml/DTD directory");
                        String modifiedPath = realSeparator + "xml" + realSeparator + "DTD" + ((String)path).substring(((String)path).lastIndexOf(realSeparator), ((String)path).length());
                        path = modifiedPath;
                    }
                    stream = FileUtil.findInputStream((String)path);
                    log.trace("attempting : {}", path);
                    if (stream != null) {
                        return new InputSource(stream);
                    }
                    log.error("did not find direct entity path: {}", path);
                    return null;
                }
                log.trace("schema file with null path");
                try {
                    return new InputSource(new FileReader(new File(source)));
                }
                catch (FileNotFoundException e2) {
                    log.error("did not find direct entity file: {}", (Object)source);
                    return null;
                }
            }
            log.error("could not parse systemId: {}", (Object)systemId);
            return null;
        }
        catch (URISyntaxException e1) {
            log.warn("Could not resolve Local Entity.", (Throwable)e1);
            return null;
        }
    }
}

