/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriThreadPoolExecutor
extends ThreadPoolExecutor {
    private final String threadName;
    private static final Logger log = LoggerFactory.getLogger(JmriThreadPoolExecutor.class);

    public JmriThreadPoolExecutor(int poolSize, String threadName) {
        super(poolSize, poolSize, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ShutDownThreadFactory(threadName));
        this.threadName = threadName;
        this.setRejectedExecutionHandler((r, executor) -> log.error("{} Task was rejected: {}", (Object)threadName, (Object)r));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone() && !future.isCancelled()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                log.error("{} Task was cancelled: {}", (Object)this.threadName, (Object)r);
            }
            catch (ExecutionException ee) {
                log.error("{} Exception in task: {}", new Object[]{this.threadName, r, ee});
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        } else if (t != null) {
            log.error("{} Exception in task execution: {}", new Object[]{this.threadName, r, t});
        }
    }

    private static class ShutDownThreadFactory
    implements ThreadFactory {
        private final String threadName;

        private ShutDownThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.threadName);
        }
    }
}

