/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class LoggingUtil {
    protected static Map<Logger, Set<String>> warnedOnce = new HashMap<Logger, Set<String>>();
    protected static Map<Logger, Set<String>> infodOnce = new HashMap<Logger, Set<String>>();
    protected static boolean logDeprecations = true;

    @SuppressFBWarnings(value={"SLF4J_UNKNOWN_ARRAY", "SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Passing arguments through")
    public static boolean warnOnce(@Nonnull Logger logger, @Nonnull String msg, Object ... args) {
        Set loggerSet = warnedOnce.computeIfAbsent(logger, l -> new HashSet());
        if (loggerSet.contains(msg)) {
            return false;
        }
        loggerSet.add(msg);
        logger.warn(msg, args);
        return true;
    }

    @SuppressFBWarnings(value={"SLF4J_UNKNOWN_ARRAY", "SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Passing arguments through")
    public static boolean infoOnce(@Nonnull Logger logger, @Nonnull String msg, Object ... args) {
        Set loggerSet = infodOnce.computeIfAbsent(logger, l -> new HashSet());
        if (loggerSet.contains(msg)) {
            return false;
        }
        loggerSet.add(msg);
        logger.info(msg, args);
        return true;
    }

    public static void deprecationWarning(@Nonnull Logger logger, @Nonnull String methodName) {
        if (logDeprecations) {
            LoggingUtil.warnOnce(logger, "{} is deprecated, please remove references to it", methodName, LoggingUtil.shortenStacktrace(new Exception("traceback")));
        }
    }

    @Nonnull
    public static <T extends Throwable> T shortenStacktrace(@Nonnull T t) {
        String name;
        int i;
        StackTraceElement[] originalTrace = t.getStackTrace();
        for (i = originalTrace.length - 1; i > 0 && ((name = originalTrace[i].getClassName()).equals("jmri.util.junit.TestClassMainMethod") || name.equals("apps.tests.AllTest") || name.equals("jmri.HeadLessTest") || !name.startsWith("jmri") && !name.startsWith("apps")); --i) {
        }
        return LoggingUtil.shortenStacktrace(t, i + 1);
    }

    @Nonnull
    public static <T extends Throwable> T shortenStacktrace(@Nonnull T t, int len) {
        StackTraceElement[] originalTrace = t.getStackTrace();
        int newLen = Math.min(len, originalTrace.length);
        StackTraceElement[] newTrace = new StackTraceElement[newLen];
        System.arraycopy(originalTrace, 0, newTrace, 0, newLen);
        t.setStackTrace(newTrace);
        return t;
    }
}

