/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public final class MathUtil {
    public static final Point2D zeroPoint2D = MathUtil.zeroPoint2D();
    public static final Point2D infinityPoint2D = MathUtil.infinityPoint2D();
    public static final Rectangle2D zeroRectangle2D = MathUtil.zeroRectangle2D();
    public static final Rectangle2D zeroToInfinityRectangle2D = MathUtil.zeroToInfinityRectangle2D();
    public static final Rectangle2D infinityRectangle2D = MathUtil.infinityRectangle2D();

    private MathUtil() {
    }

    @CheckReturnValue
    public static Point2D zeroPoint2D() {
        return new Point2D.Double(0.0, 0.0);
    }

    @CheckReturnValue
    public static Point2D infinityPoint2D() {
        return new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static int gcd(int a, int b) {
        int result = b;
        if (a != 0) {
            result = MathUtil.gcd(b % a, a);
        }
        return result;
    }

    @CheckReturnValue
    public static Point2D pointToPoint2D(@Nonnull Point p) {
        return new Point2D.Double(p.x, p.y);
    }

    @CheckReturnValue
    public static Point point2DToPoint(@Nonnull Point2D p) {
        return new Point((int)p.getX(), (int)p.getY());
    }

    public static boolean equals(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static boolean equals(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static boolean equals(Rectangle2D a, Rectangle2D b) {
        return MathUtil.equals(a.getMinX(), b.getMinX()) && MathUtil.equals(a.getMinY(), b.getMinY()) && MathUtil.equals(a.getWidth(), b.getWidth()) && MathUtil.equals(a.getHeight(), b.getHeight());
    }

    public static boolean equals(Point2D a, Point2D b) {
        return MathUtil.equals(a.getX(), b.getX()) && MathUtil.equals(a.getY(), b.getY());
    }

    public static boolean isEqualToZeroPoint2D(@Nonnull Point2D p) {
        return p.equals(zeroPoint2D);
    }

    @CheckReturnValue
    public static Point2D min(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return new Point2D.Double(Math.min(pA.getX(), pB.getX()), Math.min(pA.getY(), pB.getY()));
    }

    @CheckReturnValue
    public static Point2D max(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return new Point2D.Double(Math.max(pA.getX(), pB.getX()), Math.max(pA.getY(), pB.getY()));
    }

    @CheckReturnValue
    public static Point2D pin(@Nonnull Point2D pA, @Nonnull Point2D pB, @Nonnull Point2D pC) {
        return MathUtil.min(MathUtil.max(pA, MathUtil.min(pB, pC)), MathUtil.max(pB, pC));
    }

    @CheckReturnValue
    public static Point2D pin(@Nonnull Point2D pA, @Nonnull Rectangle2D pR) {
        return MathUtil.min(MathUtil.max(pA, MathUtil.getOrigin(pR)), MathUtil.offset(MathUtil.getOrigin(pR), pR.getWidth(), pR.getHeight()));
    }

    @CheckReturnValue
    public static Point2D add(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return new Point2D.Double(pA.getX() + pB.getX(), pA.getY() + pB.getY());
    }

    @CheckReturnValue
    public static Point2D subtract(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return new Point2D.Double(pA.getX() - pB.getX(), pA.getY() - pB.getY());
    }

    @CheckReturnValue
    public static Point2D multiply(@Nonnull Point2D p, double s) {
        return new Point2D.Double(p.getX() * s, p.getY() * s);
    }

    @CheckReturnValue
    public static Point2D multiply(@Nonnull Point2D p, double x, double y) {
        return new Point2D.Double(p.getX() * x, p.getY() * y);
    }

    public static Point2D multiply(double s, @Nonnull Point2D p) {
        return new Point2D.Double(p.getX() * s, p.getY() * s);
    }

    @CheckReturnValue
    public static Point2D multiply(@Nonnull Point2D p1, @Nonnull Point2D p2) {
        return MathUtil.multiply(p1, p2.getX(), p2.getY());
    }

    @CheckReturnValue
    public static Point2D divide(@Nonnull Point2D p, double s) {
        return new Point2D.Double(p.getX() / s, p.getY() / s);
    }

    @CheckReturnValue
    public static Point2D divide(@Nonnull Point2D p, double x, double y) {
        return new Point2D.Double(p.getX() / x, p.getY() / y);
    }

    @CheckReturnValue
    public static Point2D offset(@Nonnull Point2D p, double x, double y) {
        return new Point2D.Double(p.getX() + x, p.getY() + y);
    }

    @CheckReturnValue
    public static Point2D rotateRAD(double x, double y, double a) {
        double cosA = Math.cos(a);
        double sinA = Math.sin(a);
        return new Point2D.Double(cosA * x - sinA * y, sinA * x + cosA * y);
    }

    @CheckReturnValue
    public static Point2D rotateDEG(double x, double y, double a) {
        return MathUtil.rotateRAD(x, y, Math.toRadians(a));
    }

    @CheckReturnValue
    public static Point2D rotateRAD(@Nonnull Point2D p, double a) {
        return MathUtil.rotateRAD(p.getX(), p.getY(), a);
    }

    @CheckReturnValue
    public static Point2D rotateDEG(@Nonnull Point2D p, double a) {
        return MathUtil.rotateRAD(p, Math.toRadians(a));
    }

    @CheckReturnValue
    public static Point2D rotateRAD(@Nonnull Point2D p, @Nonnull Point2D c, double aRAD) {
        return MathUtil.add(c, MathUtil.rotateRAD(MathUtil.subtract(p, c), aRAD));
    }

    @CheckReturnValue
    public static Point2D rotateDEG(@Nonnull Point2D p, @Nonnull Point2D c, double aDEG) {
        return MathUtil.rotateRAD(p, c, Math.toRadians(aDEG));
    }

    public static Point2D orthogonal(@Nonnull Point2D p) {
        return new Point2D.Double(-p.getY(), p.getX());
    }

    @CheckReturnValue
    public static Point2D vectorDEG(double dirDEG, double magnitude) {
        Point2D.Double result = new Point2D.Double(magnitude, 0.0);
        return MathUtil.rotateDEG(result, dirDEG);
    }

    @CheckReturnValue
    public static Point2D vectorRAD(double dirRAD, double magnitude) {
        Point2D.Double result = new Point2D.Double(magnitude, 0.0);
        return MathUtil.rotateRAD(result, dirRAD);
    }

    @CheckReturnValue
    public static double dot(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return pA.getX() * pB.getX() + pA.getY() * pB.getY();
    }

    @CheckReturnValue
    public static double lengthSquared(@Nonnull Point2D p) {
        return MathUtil.dot(p, p);
    }

    @CheckReturnValue
    public static double length(@Nonnull Point2D p) {
        return Math.hypot(p.getX(), p.getY());
    }

    @CheckReturnValue
    public static double distance(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return pA.distance(pB);
    }

    @CheckReturnValue
    public static Point2D normalize(@Nonnull Point2D p, double length) {
        return MathUtil.multiply(MathUtil.normalize(p), length);
    }

    @CheckReturnValue
    public static Point2D normalize(@Nonnull Point2D p) {
        Point2D result = p;
        double length = MathUtil.length(p);
        if (length > 0.0) {
            result = MathUtil.divide(p, length);
        }
        return result;
    }

    @CheckReturnValue
    public static double computeAngleRAD(@Nonnull Point2D p) {
        return Math.atan2(p.getX(), p.getY());
    }

    @CheckReturnValue
    public static double computeAngleDEG(@Nonnull Point2D p) {
        return Math.toDegrees(MathUtil.computeAngleRAD(p));
    }

    @CheckReturnValue
    public static double computeAngleRAD(@Nonnull Point2D p1, @Nonnull Point2D p2) {
        return MathUtil.computeAngleRAD(MathUtil.subtract(p1, p2));
    }

    @CheckReturnValue
    public static double computeAngleDEG(@Nonnull Point2D p1, @Nonnull Point2D p2) {
        return Math.toDegrees(MathUtil.computeAngleRAD(MathUtil.subtract(p1, p2)));
    }

    public static int lerp(int a, int b, double t) {
        return (int)MathUtil.lerp((double)a, (double)b, t);
    }

    @CheckReturnValue
    public static double lerp(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    @CheckReturnValue
    public static Double lerp(@Nonnull Double a, @Nonnull Double b, @Nonnull Double t) {
        return (1.0 - t) * a + t * b;
    }

    @CheckReturnValue
    public static Point2D lerp(@Nonnull Point2D pA, @Nonnull Point2D pB, double t) {
        return new Point2D.Double(MathUtil.lerp(pA.getX(), pB.getX(), t), MathUtil.lerp(pA.getY(), pB.getY(), t));
    }

    @CheckReturnValue
    public static double granulize(double v, double g) {
        return (double)Math.round(v / g) * g;
    }

    @CheckReturnValue
    public static Point2D granulize(@Nonnull Point2D p, double gH, double gV) {
        return new Point2D.Double(MathUtil.granulize(p.getX(), gH), MathUtil.granulize(p.getY(), gV));
    }

    @CheckReturnValue
    public static Point2D granulize(@Nonnull Point2D p, double g) {
        return MathUtil.granulize(p, g, g);
    }

    @CheckReturnValue
    public static Rectangle2D granulize(@Nonnull Rectangle2D r, double g) {
        return new Rectangle2D.Double(MathUtil.granulize(r.getMinX(), g), MathUtil.granulize(r.getMinY(), g), MathUtil.granulize(r.getWidth(), g), MathUtil.granulize(r.getHeight(), g));
    }

    @CheckReturnValue
    public static Point2D midPoint(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return MathUtil.lerp(pA, pB, 0.5);
    }

    @CheckReturnValue
    public static Point2D oneThirdPoint(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return MathUtil.lerp(pA, pB, 0.3333333333333333);
    }

    @CheckReturnValue
    public static Point2D twoThirdsPoint(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return MathUtil.lerp(pA, pB, 0.6666666666666666);
    }

    @CheckReturnValue
    public static Point2D oneFourthPoint(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return MathUtil.lerp(pA, pB, 0.25);
    }

    @CheckReturnValue
    public static Point2D threeFourthsPoint(@Nonnull Point2D pA, @Nonnull Point2D pB) {
        return MathUtil.lerp(pA, pB, 0.75);
    }

    public static int wrap(int inValue, int inMin, int inMax) {
        int valueRange = inMax - inMin;
        return inMin + ((inValue - inMin) % valueRange + valueRange) % valueRange;
    }

    @CheckReturnValue
    public static double wrap(double inValue, double inMin, double inMax) {
        double valueRange = inMax - inMin;
        return inMin + ((inValue - inMin) % valueRange + valueRange) % valueRange;
    }

    @CheckReturnValue
    public static double wrapPM180(double inValue) {
        return MathUtil.wrap(inValue, -180.0, 180.0);
    }

    @CheckReturnValue
    public static double wrapPM360(double inValue) {
        return MathUtil.wrap(inValue, -360.0, 360.0);
    }

    @CheckReturnValue
    public static double wrap360(double inValue) {
        return MathUtil.wrap(inValue, 0.0, 360.0);
    }

    @CheckReturnValue
    public static double normalizeAngleDEG(double a) {
        return MathUtil.wrap360(a);
    }

    @CheckReturnValue
    public static double diffAngleDEG(double a, double b) {
        return MathUtil.wrapPM180(a - b);
    }

    @CheckReturnValue
    public static double absDiffAngleDEG(double a, double b) {
        return Math.abs(MathUtil.diffAngleDEG(a, b));
    }

    @CheckReturnValue
    public static double diffAngleRAD(double a, double b) {
        return MathUtil.wrap(a - b, -Math.PI, Math.PI);
    }

    @CheckReturnValue
    public static double absDiffAngleRAD(double a, double b) {
        return Math.abs(MathUtil.diffAngleRAD(a, b));
    }

    public static int pin(int inValue, int inMin, int inMax) {
        return Math.min(Math.max(inValue, inMin), inMax);
    }

    @CheckReturnValue
    public static double pin(double inValue, double inMin, double inMax) {
        return Math.min(Math.max(inValue, inMin), inMax);
    }

    @CheckReturnValue
    public static Rectangle2D zeroRectangle2D() {
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    @CheckReturnValue
    public static Rectangle2D zeroToInfinityRectangle2D() {
        return new Rectangle2D.Double(0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @CheckReturnValue
    public static Rectangle2D infinityRectangle2D() {
        return new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Nonnull
    public static String rectangle2DToString(@Nonnull Rectangle2D r) {
        return String.format(Locale.getDefault(), "{%.2f, %.2f, %.2f, %.2f}", r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    @CheckReturnValue
    public static Rectangle2D rectangleToRectangle2D(@Nonnull Rectangle r) {
        return new Rectangle2D.Double(r.x, r.y, r.width, r.height);
    }

    @CheckReturnValue
    public static Rectangle rectangle2DToRectangle(@Nonnull Rectangle2D r) {
        return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @CheckReturnValue
    public static Point2D getOrigin(@Nonnull Rectangle2D r) {
        return new Point2D.Double(r.getX(), r.getY());
    }

    @CheckReturnValue
    public static Rectangle2D setOrigin(@Nonnull Rectangle2D r, @Nonnull Point2D origin) {
        return new Rectangle2D.Double(origin.getX(), origin.getY(), r.getWidth(), r.getHeight());
    }

    @Nonnull
    public static String dimensionToString(@Nonnull Dimension d) {
        return String.format(Locale.getDefault(), "{%.2f, %.2f}", d.getWidth(), d.getHeight());
    }

    @CheckReturnValue
    public static Dimension getSize(@Nonnull Rectangle2D r) {
        return new Dimension((int)r.getWidth(), (int)r.getHeight());
    }

    @CheckReturnValue
    public static Rectangle2D setSize(@Nonnull Rectangle2D r, @Nonnull Dimension d) {
        return new Rectangle2D.Double(r.getMinX(), r.getMinY(), d.getWidth(), d.getHeight());
    }

    @CheckReturnValue
    public static Rectangle2D setSize(@Nonnull Rectangle2D r, @Nonnull Point2D s) {
        return new Rectangle2D.Double(r.getMinX(), r.getMinY(), s.getX(), s.getY());
    }

    @CheckReturnValue
    public static Point2D center(@Nonnull Rectangle2D r) {
        return new Point2D.Double(r.getCenterX(), r.getCenterY());
    }

    @CheckReturnValue
    public static Point2D midPoint(@Nonnull Rectangle2D r) {
        return MathUtil.center(r);
    }

    @CheckReturnValue
    public static Rectangle2D offset(@Nonnull Rectangle2D r, double x, double y) {
        return new Rectangle2D.Double(r.getX() + x, r.getY() + y, r.getWidth(), r.getHeight());
    }

    @CheckReturnValue
    public static Rectangle2D offset(@Nonnull Rectangle2D r, @Nonnull Point2D o) {
        return MathUtil.offset(r, o.getX(), o.getY());
    }

    @CheckReturnValue
    public static Rectangle2D inset(@Nonnull Rectangle2D r, double i) {
        return MathUtil.inset(r, i, i);
    }

    @CheckReturnValue
    public static Rectangle2D inset(@Nonnull Rectangle2D r, double h, double v) {
        return new Rectangle2D.Double(r.getX() + h, r.getY() + v, r.getWidth() - 2.0 * h, r.getHeight() - 2.0 * v);
    }

    @CheckReturnValue
    public static Rectangle2D scale(@Nonnull Rectangle2D r, double s) {
        return new Rectangle2D.Double(r.getX() * s, r.getY() * s, r.getWidth() * s, r.getHeight() * s);
    }

    @CheckReturnValue
    public static Rectangle2D centerRectangleOnPoint(@Nonnull Rectangle2D r, @Nonnull Point2D p) {
        Rectangle2D result = r.getBounds2D();
        result = MathUtil.offset(r, MathUtil.subtract(p, MathUtil.center(result)));
        return result;
    }

    @CheckReturnValue
    public static Rectangle2D centerRectangleOnRectangle(@Nonnull Rectangle2D r1, @Nonnull Rectangle2D r2) {
        return MathUtil.offset(r1, MathUtil.subtract(MathUtil.center(r2), MathUtil.center(r1)));
    }

    @CheckReturnValue
    public static Rectangle2D rectangleAtPoint(@Nonnull Point2D p, Double width, Double height) {
        return new Rectangle2D.Double(p.getX(), p.getY(), width, height);
    }

    private static double plotBezier(GeneralPath path, @Nonnull Point2D p0, @Nonnull Point2D p1, @Nonnull Point2D p2, @Nonnull Point2D p3, int depth, double displacement) {
        double result;
        double l01 = MathUtil.distance(p0, p1);
        double l12 = MathUtil.distance(p1, p2);
        double l23 = MathUtil.distance(p2, p3);
        double l03 = MathUtil.distance(p0, p3);
        double flatness = (l01 + l12 + l23) / l03;
        if (depth > 12 || flatness <= 1.001) {
            Point2D vO = MathUtil.normalize(MathUtil.orthogonal(MathUtil.subtract(p3, p0)), displacement);
            if (path.getCurrentPoint() == null) {
                Point2D p0P = MathUtil.add(p0, vO);
                path.moveTo(p0P.getX(), p0P.getY());
            }
            Point2D p3P = MathUtil.add(p3, vO);
            path.lineTo(p3P.getX(), p3P.getY());
            result = l03;
        } else {
            Point2D q0 = MathUtil.midPoint(p0, p1);
            Point2D q1 = MathUtil.midPoint(p1, p2);
            Point2D q2 = MathUtil.midPoint(p2, p3);
            Point2D r0 = MathUtil.midPoint(q0, q1);
            Point2D r1 = MathUtil.midPoint(q1, q2);
            Point2D s = MathUtil.midPoint(r0, r1);
            result = MathUtil.plotBezier(path, p0, q0, r0, s, depth + 1, displacement);
            result += MathUtil.plotBezier(path, s, r1, q2, p3, depth + 1, displacement);
        }
        return result;
    }

    public static double drawBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D p0, @Nonnull Point2D p1, @Nonnull Point2D p2, @Nonnull Point2D p3) {
        GeneralPath path = new GeneralPath();
        double result = MathUtil.plotBezier(path, p0, p1, p2, p3, 0, 0.0);
        if (g2 != null) {
            g2.draw(path);
        }
        return result;
    }

    private static double plotBezier(GeneralPath path, @Nonnull Point2D[] points, int depth, double displacement) {
        double result;
        int idx;
        int len = points.length;
        double outer_distance = 0.0;
        for (idx = 1; idx < len; ++idx) {
            outer_distance += MathUtil.distance(points[idx - 1], points[idx]);
        }
        double inner_distance = MathUtil.distance(points[0], points[len - 1]);
        double flatness = outer_distance / inner_distance;
        if (depth > 12 || flatness <= 1.001) {
            Point2D p0 = points[0];
            Point2D pN = points[len - 1];
            Point2D vO = MathUtil.normalize(MathUtil.orthogonal(MathUtil.subtract(pN, p0)), displacement);
            if (path.getCurrentPoint() == null) {
                Point2D p0P = MathUtil.add(p0, vO);
                path.moveTo(p0P.getX(), p0P.getY());
            }
            Point2D pNP = MathUtil.add(pN, vO);
            path.lineTo(pNP.getX(), pNP.getY());
            result = inner_distance;
        } else {
            Point2D[][] nthOrderPoints = new Point2D[len - 1][];
            for (idx = 0; idx < len - 1; ++idx) {
                nthOrderPoints[idx] = new Point2D[len - 1 - idx];
                for (int jdx = 0; jdx < len - 1 - idx; ++jdx) {
                    nthOrderPoints[idx][jdx] = idx == 0 ? MathUtil.midPoint(points[jdx], points[jdx + 1]) : MathUtil.midPoint(nthOrderPoints[idx - 1][jdx], nthOrderPoints[idx - 1][jdx + 1]);
                }
            }
            Point2D[] leftPoints = new Point2D[len];
            leftPoints[0] = points[0];
            for (idx = 0; idx < len - 1; ++idx) {
                leftPoints[idx + 1] = nthOrderPoints[idx][0];
            }
            result = MathUtil.plotBezier(path, leftPoints, depth + 1, displacement);
            Point2D[] rightPoints = new Point2D[len];
            for (idx = 0; idx < len - 1; ++idx) {
                rightPoints[idx] = nthOrderPoints[len - 2 - idx][idx];
            }
            rightPoints[idx] = points[len - 1];
            result += MathUtil.plotBezier(path, rightPoints, depth + 1, displacement);
        }
        return result;
    }

    private static double plotBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D[] p, double displacement, boolean fillFlag) {
        GeneralPath path = new GeneralPath();
        double result = p.length == 4 ? MathUtil.plotBezier(path, p[0], p[1], p[2], p[3], 0, displacement) : MathUtil.plotBezier(path, p, 0, displacement);
        if (g2 != null) {
            if (fillFlag) {
                g2.fill(path);
            } else {
                g2.draw(path);
            }
        }
        return result;
    }

    public static GeneralPath getBezierPath(@Nonnull Point2D[] p, double displacement) {
        GeneralPath result = new GeneralPath();
        if (p.length == 4) {
            MathUtil.plotBezier(result, p[0], p[1], p[2], p[3], 0, displacement);
        } else {
            MathUtil.plotBezier(result, p, 0, displacement);
        }
        return result;
    }

    public static GeneralPath getBezierPath(@Nonnull Point2D[] p) {
        return MathUtil.getBezierPath(p, 0.0);
    }

    public static double drawBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D[] p, double displacement) {
        return MathUtil.plotBezier(g2, p, displacement, false);
    }

    public static double fillBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D[] p, double displacement) {
        return MathUtil.plotBezier(g2, p, displacement, true);
    }

    public static double drawBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D[] p) {
        return MathUtil.drawBezier(g2, p, 0.0);
    }

    public static double fillBezier(@CheckForNull Graphics2D g2, @Nonnull Point2D[] p) {
        return MathUtil.plotBezier(g2, p, 0.0, true);
    }

    public static Rectangle2D getBezierBounds(@Nonnull Point2D[] p) {
        return MathUtil.getBezierPath(p).getBounds2D();
    }

    @CheckReturnValue
    public static Point2D intersect(@Nonnull Point2D p1, @Nonnull Point2D p2, @Nonnull Point2D p3, @Nonnull Point2D p4) {
        Point2D result = null;
        Point2D delta31 = MathUtil.subtract(p3, p1);
        Point2D delta21 = MathUtil.subtract(p2, p1);
        Point2D delta43 = MathUtil.subtract(p4, p3);
        double det = delta21.getX() * delta43.getY() - delta21.getY() * delta43.getX();
        if (!MathUtil.equals(det, 0.0)) {
            double t = (delta21.getY() * delta31.getX() - delta21.getX() * delta31.getY()) / det;
            result = MathUtil.lerp(p1, p2, t);
        }
        return result;
    }

    public static double distance(@Nonnull Point2D p1, @Nonnull Point2D p2, @Nonnull Point2D p3) {
        double p1X = p1.getX();
        double p1Y = p1.getY();
        double p2X = p2.getX();
        double p2Y = p2.getY();
        double p3X = p3.getX();
        double p3Y = p3.getY();
        double a = p1Y - p2Y;
        double b = p2X - p1X;
        double c = p1X * p2Y - p2X * p1Y;
        return (a * p3X + b * p3Y + c) / Math.sqrt(a * a + b * b);
    }

    public static Point2D midPoint(List<Point2D> points) {
        Point2D result = MathUtil.zeroPoint2D();
        for (Point2D point : points) {
            result = MathUtil.add(result, point);
        }
        result = MathUtil.divide(result, points.size());
        return result;
    }

    public static boolean isPointInPolygon(Point2D pointT, List<Point2D> points) {
        boolean result = false;
        Double pointT_x = pointT.getX();
        Double pointT_y = pointT.getY();
        int n = points.size();
        int i = 0;
        int j = n - 1;
        while (i < n) {
            Point2D pointI = points.get(i);
            Point2D pointJ = points.get(j);
            Double pointI_x = pointI.getX();
            Double pointI_y = pointI.getY();
            Double pointJ_x = pointJ.getX();
            Double pointJ_y = pointJ.getY();
            if (pointI_y > pointT_y != pointJ_y > pointT_y && pointT_x < (pointJ_x - pointI_x) * (pointT_y - pointI_y) / (pointJ_y - pointI_y) + pointI_x) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static List<Point2D> convexHull(List<Point2D> points) {
        if (points.isEmpty()) {
            return points;
        }
        points.sort((p1, p2) -> (int)Math.signum(p1.getX() - p2.getX()));
        ArrayList<Point2D> results = new ArrayList<Point2D>();
        for (Point2D pt : points) {
            int n;
            while (results.size() > 1 && !MathUtil.isCounterClockWise((Point2D)results.get((n = results.size()) - 2), (Point2D)results.get(n - 1), pt)) {
                results.remove(n - 1);
            }
            results.add(pt);
        }
        int t = results.size();
        for (int i = points.size() - 1; i >= 0; --i) {
            int n;
            Point2D pt = points.get(i);
            while (results.size() > t && !MathUtil.isCounterClockWise((Point2D)results.get((n = results.size()) - 2), (Point2D)results.get(n - 1), pt)) {
                results.remove(n - 1);
            }
            results.add(pt);
        }
        results.remove(results.size() - 1);
        return results;
    }

    public static boolean isCounterClockWise(Point2D a, Point2D b, Point2D c) {
        return (b.getX() - a.getX()) * (c.getY() - a.getY()) > (b.getY() - a.getY()) * (c.getX() - a.getX());
    }
}

