/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuScroller
implements MouseWheelListener {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollerItem upItem;
    private MenuScrollerItem downItem;
    private final MenuScrollerPopupMenuListener menuScrollerPopupMenuListener = new MenuScrollerPopupMenuListener();
    private final MenuScrollerMenuKeyListener menuScrollerMenuKeyListener = new MenuScrollerMenuKeyListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    private int keepVisibleIndex = -1;
    private static final Logger log = LoggerFactory.getLogger(MenuScroller.class);

    public static MenuScroller setScrollerFor(JMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public MenuScroller(JMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JPopupMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        this(menu.getPopupMenu(), scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        if (scrollCount <= 0 || interval <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (topFixedCount < 0 || bottomFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollerItem(MenuScrollerIcon.UP, -1);
        this.downItem = new MenuScrollerItem(MenuScrollerIcon.DOWN, 1);
        this.setScrollCount(scrollCount);
        this.setInterval(interval);
        this.setTopFixedCount(topFixedCount);
        this.setBottomFixedCount(bottomFixedCount);
        this.menu = menu;
        this.installListeners();
    }

    private void installListeners() {
        for (MenuKeyListener mkl : this.menu.getMenuKeyListeners()) {
            this.menu.removeMenuKeyListener(mkl);
        }
        this.menu.addMenuKeyListener(this.menuScrollerMenuKeyListener);
        this.menu.addPopupMenuListener(this.menuScrollerPopupMenuListener);
        this.menu.addMouseWheelListener(this);
    }

    private void removeListeners() {
        this.menu.removePopupMenuListener(this.menuScrollerPopupMenuListener);
        this.menu.removeMouseWheelListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int amount = e.getScrollAmount() * e.getWheelRotation();
        this.firstIndex += amount;
        this.refreshMenu();
        e.consume();
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public void setScrollCount(int scrollCount) {
        if (scrollCount <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = scrollCount;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int topFixedCount) {
        this.firstIndex = this.firstIndex <= topFixedCount ? topFixedCount : (this.firstIndex += topFixedCount - this.topFixedCount);
        this.topFixedCount = topFixedCount;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public void setBottomFixedCount(int bottomFixedCount) {
        this.bottomFixedCount = bottomFixedCount;
    }

    public void keepVisible(JMenuItem item) {
        int index;
        this.keepVisibleIndex = item == null ? -1 : (index = this.menu.getComponentIndex(item));
    }

    public void keepVisible(int index) {
        this.keepVisibleIndex = index;
    }

    public void dispose() {
        if (this.menu != null) {
            this.removeListeners();
            this.menu = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i;
            this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
            this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
            this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
            this.downItem.setEnabled(this.firstIndex + this.scrollCount < this.menuItems.length - this.bottomFixedCount);
            this.menu.removeAll();
            for (i = 0; i < this.topFixedCount; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            if (this.topFixedCount > 0) {
                this.menu.addSeparator();
            }
            this.menu.add(this.upItem);
            for (i = this.firstIndex; i < this.scrollCount + this.firstIndex; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            this.menu.add(this.downItem);
            if (this.bottomFixedCount > 0) {
                this.menu.addSeparator();
            }
            for (i = this.menuItems.length - this.bottomFixedCount; i < this.menuItems.length; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            int maxPreferredWidth = 0;
            for (Component item : this.menuItems) {
                maxPreferredWidth = Math.max(maxPreferredWidth, item.getPreferredSize().width);
            }
            this.menu.setPreferredSize(new Dimension(maxPreferredWidth, this.menu.getPreferredSize().height));
            Container cont = this.upItem.getParent();
            if (cont instanceof JComponent) {
                ((JComponent)cont).revalidate();
                ((JComponent)cont).repaint();
            }
        }
    }

    private static enum MenuScrollerIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuScrollerIcon(int ... yPoints) {
            this.yPoints = yPoints;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Dimension size = c.getSize();
            Graphics g2 = g.create(size.width / 2 - 5, size.height / 2 - 5, 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawPolygon(this.xPoints, this.yPoints, 3);
            if (c.isEnabled()) {
                g2.setColor(Color.BLACK);
                g2.fillPolygon(this.xPoints, this.yPoints, 3);
            }
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollerMenuKeyListener
    implements MenuKeyListener {
        private MenuScrollerMenuKeyListener() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
            int keyCode = e.getKeyCode();
            log.debug("MenuScroller.keyTyped({})", (Object)keyCode);
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            int keyCode = e.getKeyCode();
            log.debug("MenuScroller.keyPressed({})", (Object)keyCode);
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 38: {
                    log.debug("MenuScroller.keyReleased(VK_UP)");
                    --MenuScroller.this.firstIndex;
                    MenuScroller.this.refreshMenu();
                    e.consume();
                    break;
                }
                case 40: {
                    log.debug("MenuScroller.keyReleased(VK_DOWN)");
                    ++MenuScroller.this.firstIndex;
                    MenuScroller.this.refreshMenu();
                    e.consume();
                    break;
                }
                default: {
                    log.debug("MenuScroller.keyReleased({})", (Object)keyCode);
                }
            }
        }
    }

    private class MenuScrollerItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollerTimer timer;

        public MenuScrollerItem(MenuScrollerIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.timer = new MenuScrollerTimer(increment, MenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollerTimer
    extends Timer {
        public MenuScrollerTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuScroller.this.firstIndex += increment;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollerPopupMenuListener
    implements PopupMenuListener {
        private MenuScrollerPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.this.menuItems = MenuScroller.this.menu.getComponents();
            if (MenuScroller.this.keepVisibleIndex >= MenuScroller.this.topFixedCount && MenuScroller.this.keepVisibleIndex <= MenuScroller.this.menuItems.length - MenuScroller.this.bottomFixedCount && (MenuScroller.this.keepVisibleIndex > MenuScroller.this.firstIndex + MenuScroller.this.scrollCount || MenuScroller.this.keepVisibleIndex < MenuScroller.this.firstIndex)) {
                MenuScroller.this.firstIndex = Math.min(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex);
                MenuScroller.this.firstIndex = Math.max(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex - MenuScroller.this.scrollCount + 1);
            }
            if (MenuScroller.this.menuItems.length > MenuScroller.this.topFixedCount + MenuScroller.this.scrollCount + MenuScroller.this.bottomFixedCount) {
                MenuScroller.this.refreshMenu();
            }
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component c : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(c);
            }
        }
    }
}

