/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class NoArchiveFileFilter
extends FileFilter {
    private final String description;
    private final Set<String> extensions = new HashSet<String>();

    public NoArchiveFileFilter() {
        this("Omit archive files");
    }

    public NoArchiveFileFilter(String description) {
        this.description = description;
    }

    public NoArchiveFileFilter(String description, String ... extensions) {
        this(description);
        Arrays.stream(extensions).filter(e -> e != null).forEach(e -> this.extensions.add((String)e));
    }

    @Override
    public boolean accept(File f) {
        if (f.getName().toLowerCase(Locale.ROOT).matches(".*\\.zip") || f.getName().toLowerCase(Locale.ROOT).matches(".*\\.jar")) {
            return false;
        }
        return f.isDirectory() || this.extensions.contains(FilenameUtils.getExtension((String)f.getName()));
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

