/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class NonNullArrayList<E>
extends ArrayList<E> {
    @Override
    public boolean add(@Nonnull E e) {
        if (e == null) {
            throw new IllegalArgumentException("NonNullArrayList.addAll cannot add null item");
        }
        return super.add(e);
    }

    @Override
    public void add(int i, @Nonnull E e) {
        if (e == null) {
            throw new IllegalArgumentException("NonNullArrayList.addAll cannot add null item");
        }
        super.add(i, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            if (e != null) continue;
            throw new IllegalArgumentException("NonNullArrayList.addAll cannot accept collection containing null");
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        for (E e : c) {
            if (e != null) continue;
            throw new IllegalArgumentException("NonNullArrayList.addAll cannot accept collection containing null");
        }
        return super.addAll(i, c);
    }

    @Override
    @Nonnull
    public E get(int i) {
        return super.get(i);
    }

    @Override
    @Nonnull
    public E remove(int i) {
        return super.remove(i);
    }

    @Override
    @Nonnull
    public E set(int i, @Nonnull E e) {
        if (e == null) {
            throw new IllegalArgumentException("NonNullArrayList.addAll cannot set item null");
        }
        return super.set(i, e);
    }

    protected NonNullArrayList<Integer> testAddAndReturn() {
        NonNullArrayList<Integer> t = new NonNullArrayList<Integer>();
        t.add(100);
        return t;
    }

    protected boolean testLoop(String c) {
        NonNullArrayList<Integer> t = new NonNullArrayList<Integer>();
        t.add(100);
        for (Integer s : t) {
            if (!s.toString().equals(c)) continue;
            return true;
        }
        return false;
    }

    protected boolean asArgumentCheck(NonNullArrayList<Integer> t) {
        if (t.get(0).toString().equals("100")) {
            return true;
        }
        for (Integer s : t) {
            if (!s.toString().equals("123")) continue;
            return true;
        }
        return false;
    }
}

