/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalLocationPanel
extends JPanel {
    TitledBorder tb;
    JSpinner xs;
    JSpinner ys;
    JSpinner zs;
    SpinnerNumberModel spinnerModel;
    static final Float min_spin = Float.valueOf(-1000.0f);
    static final Float max_spin = Float.valueOf(1000.0f);
    static final Float spin_value = Float.valueOf(0.0f);
    static final Float spin_inc = Float.valueOf(0.1f);
    private static final Logger log = LoggerFactory.getLogger(PhysicalLocationPanel.class);

    public PhysicalLocationPanel() {
        this.initComponents("");
    }

    public PhysicalLocationPanel(String title) {
        this.initComponents(title);
    }

    private GridBagConstraints setConstraints(int x, int y, boolean fill) {
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = new Insets(2, 2, 2, 2);
        gbc1.gridx = x;
        gbc1.gridy = y;
        gbc1.weightx = 100.0;
        gbc1.weighty = 100.0;
        gbc1.gridwidth = 1;
        gbc1.anchor = 21;
        return gbc1;
    }

    protected void initComponents(String title) {
        this.tb = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), title);
        this.tb.setTitlePosition(0);
        this.setBorder(this.tb);
        this.setLayout(new GridBagLayout());
        this.xs = new JSpinner(new SpinnerNumberModel(spin_value, min_spin, max_spin, spin_inc));
        this.ys = new JSpinner(new SpinnerNumberModel(spin_value, min_spin, max_spin, spin_inc));
        this.zs = new JSpinner(new SpinnerNumberModel(spin_value, min_spin, max_spin, spin_inc));
        JLabel xl = new JLabel("X");
        JLabel yl = new JLabel("Y");
        JLabel zl = new JLabel("Z");
        this.add((Component)xl, this.setConstraints(0, 0, false));
        this.add((Component)this.xs, this.setConstraints(-1, 0, true));
        this.add((Component)yl, this.setConstraints(-1, 0, false));
        this.add((Component)this.ys, this.setConstraints(-1, 0, true));
        this.add((Component)zl, this.setConstraints(-1, 0, false));
        this.add((Component)this.zs, this.setConstraints(-1, 0, true));
        this.setVisible(true);
        log.debug("initComponents() complete");
    }

    public void setTitle(String t) {
        this.tb.setTitle(t);
    }

    public String getTitle() {
        return this.tb.getTitle();
    }

    public void setValue(PhysicalLocation p) {
        this.xs.setValue(Float.valueOf(p.getX()));
        this.ys.setValue(Float.valueOf(p.getY()));
        this.zs.setValue(Float.valueOf(p.getZ()));
    }

    public void setValue(String s) {
        PhysicalLocation p = PhysicalLocation.parse(s);
        if (p != null) {
            this.setValue(p);
        }
    }

    public PhysicalLocation getValue() {
        Float x = (Float)((SpinnerNumberModel)this.xs.getModel()).getNumber();
        Float y = (Float)((SpinnerNumberModel)this.ys.getModel()).getNumber();
        Float z = (Float)((SpinnerNumberModel)this.zs.getModel()).getNumber();
        return new PhysicalLocation(x.floatValue(), y.floatValue(), z.floatValue());
    }
}

