/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceWindow
implements InstanceManagerAutoDefault {
    static GraphicsEnvironment _environ = GraphicsEnvironment.getLocalGraphicsEnvironment();
    static Dimension[] _screenSize;
    static Dimension _totalScreenDim;
    private static final Logger log;

    public PlaceWindow() {
        this.getScreens();
    }

    private void getScreens() {
        GraphicsDevice[] gd = _environ.getScreenDevices();
        _screenSize = new Dimension[gd.length];
        int maxHeight = 0;
        for (int i = 0; i < gd.length; ++i) {
            String deviceID = gd[i].getIDstring();
            DisplayMode dm = gd[i].getDisplayMode();
            PlaceWindow._screenSize[i] = new Dimension(dm.getWidth(), dm.getHeight());
            PlaceWindow._totalScreenDim.width += dm.getWidth();
            maxHeight = Math.max(maxHeight, dm.getHeight());
            if (!log.isDebugEnabled()) continue;
            log.debug("\"Screen # {} deviceID= {}: width= {}, height= {}", new Object[]{i, deviceID, dm.getWidth(), dm.getHeight()});
        }
        PlaceWindow._totalScreenDim.height = maxHeight;
        if (log.isDebugEnabled()) {
            try {
                GraphicsDevice dgd = _environ.getDefaultScreenDevice();
                DisplayMode dm = dgd.getDisplayMode();
                log.debug("\"DefaultScreen= {}: width= {}, height= {}", new Object[]{dgd.getIDstring(), dm.getWidth(), dm.getHeight()});
                log.debug("\"Total Screen size: width= {}, height= {}", (Object)PlaceWindow._totalScreenDim.width, (Object)PlaceWindow._totalScreenDim.height);
            }
            catch (IllegalComponentStateException icse) {
                log.debug("unable to construct debug information due to illegal component state");
            }
        }
    }

    public static PlaceWindow getDefault() {
        return InstanceManager.getOptionalDefault(PlaceWindow.class).orElseGet(() -> InstanceManager.setDefault(PlaceWindow.class, new PlaceWindow()));
    }

    public int getScreenNum(Window window) {
        int x = 0;
        try {
            for (int i = 0; i < _screenSize.length; ++i) {
                if (window.getLocation().x >= (x += PlaceWindow._screenSize[i].width)) continue;
                return i;
            }
        }
        catch (IllegalComponentStateException icse) {
            return 0;
        }
        return 0;
    }

    public Dimension getScreenSize(int screenNum) {
        if (screenNum >= 0 && screenNum <= _screenSize.length) {
            return _screenSize[screenNum];
        }
        return new Dimension(0, 0);
    }

    public Point nextTo(Window parent, Component comp, Window target) {
        if (target == null || parent == null) {
            return new Point(0, 0);
        }
        Point loc = this.findLocation(parent, comp, target);
        if (log.isDebugEnabled()) {
            log.debug("return target location: X= {}, Y= {}", (Object)loc.x, (Object)loc.y);
        }
        target.setLocation(loc);
        return loc;
    }

    private Point findLocation(Window parent, Component comp, Window target) {
        int offScreen;
        int margin;
        Dimension compDim;
        Point compLoc;
        Point parentLoc = parent.getLocation();
        Dimension parentDim = parent.getSize();
        int screenNum = this.getScreenNum(parent);
        Dimension parentScreen = this.getScreenSize(screenNum);
        Dimension targetDim = target.getPreferredSize();
        if (comp != null) {
            try {
                compLoc = new Point(comp.getLocationOnScreen());
            }
            catch (IllegalComponentStateException icse) {
                compLoc = comp.getLocation();
                compLoc = new Point(compLoc.x + parentLoc.x, compLoc.y + parentLoc.y);
            }
            compDim = comp.getSize();
            margin = 20;
        } else {
            compLoc = parentLoc;
            compDim = parentDim;
            margin = 0;
        }
        int screenLeft = 0;
        for (int num = screenNum - 1; num >= 0; --num) {
            screenLeft += this.getScreenSize((int)num).width;
        }
        int screenRight = screenLeft + parentScreen.width;
        if (log.isDebugEnabled()) {
            log.debug("parent at loc ({}, {}) is on screen #{}. Size: width= {}, height= {}", new Object[]{parentLoc.x, parentLoc.y, screenNum, parentDim.width, parentDim.height});
            log.debug("Component at loc ({}, {}). Size: width= {}, height= {}", new Object[]{compLoc.x, compLoc.y, compDim.width, compDim.height});
            log.debug("targetDim: width= {}, height= {}. screenLeft= {}, screen= {} x {}", new Object[]{targetDim.width, targetDim.height, screenLeft, parentScreen.width, parentScreen.height});
        }
        int xr = compLoc.x + compDim.width + margin;
        int xl = compLoc.x - targetDim.width - margin;
        int hOff = compLoc.y + (compDim.height - targetDim.height) / 2;
        if (hOff + targetDim.height > parentScreen.height) {
            hOff = parentScreen.height - targetDim.height;
        }
        if (hOff < 0) {
            hOff = 0;
        }
        int yb = compLoc.y + compDim.height + margin;
        int ya = compLoc.y - targetDim.height - margin;
        int vOff = compLoc.x + (compDim.width - targetDim.width) / 2;
        if (vOff + targetDim.width > parentScreen.width - targetDim.width) {
            vOff = parentScreen.width - targetDim.width;
        }
        if (vOff < screenLeft) {
            vOff = screenLeft;
        }
        if (log.isDebugEnabled()) {
            log.debug("UpperleftCorners: xl=({},{}), xr=({},{}), yb=({},{}), ya=({},{})", new Object[]{xl, hOff, xr, hOff, vOff, yb, vOff, ya});
        }
        if (xl >= parentLoc.x) {
            return new Point(xl, hOff);
        }
        if (xr + targetDim.width <= parentLoc.x + parentDim.width) {
            return new Point(xr, hOff);
        }
        if (yb + targetDim.height <= parentLoc.y + parentDim.height) {
            return new Point(vOff, yb);
        }
        if (ya >= parentLoc.y) {
            if (ya < 0) {
                ya = 0;
            }
            return new Point(vOff, ya);
        }
        if (log.isDebugEnabled()) {
            log.debug("Off screen: left= {}, right = {}, below= {}, above= {}", new Object[]{xl, xr, yb, ya});
        }
        if (xl > screenLeft) {
            return new Point(xl, hOff);
        }
        if (xr + targetDim.width <= screenRight) {
            return new Point(xr, hOff);
        }
        if (yb + targetDim.height <= parentScreen.height) {
            return new Point(vOff, yb);
        }
        if (ya >= 0) {
            return new Point(vOff, ya);
        }
        if (log.isDebugEnabled()) {
            log.debug("Outside: widthUpToParent= {},  _totalScreenWidth= {}, screenHeight={}", new Object[]{parentLoc.x, PlaceWindow._totalScreenDim.width, parentScreen.height});
        }
        int minOff = offScreen = screenLeft - xl;
        log.debug("offScreen= {} minOff= {}, xl= {}", new Object[]{offScreen, minOff, xl});
        if (xl < 0) {
            xl = 0;
        }
        Point loc = new Point(xl, hOff);
        offScreen = xr + targetDim.width - screenRight;
        xr = screenRight - targetDim.width;
        log.debug("offScreen= {}  minOff= {}, xr= {}", new Object[]{offScreen, minOff, xr});
        if (offScreen < minOff) {
            minOff = offScreen;
            loc = new Point(xr, hOff);
        }
        offScreen = yb + targetDim.height - parentScreen.height;
        yb = parentScreen.height - targetDim.height;
        log.debug("offScreen= {} minOff = {}, yb= {}", new Object[]{offScreen, minOff, yb});
        if (offScreen < minOff) {
            minOff = offScreen;
            if (yb < 0) {
                yb = 0;
            }
            loc = new Point(vOff, yb);
        }
        offScreen = -ya;
        log.debug("offScreen= {} minOff = {}, ya= {}", new Object[]{offScreen, minOff, ya});
        if (offScreen < minOff) {
            ya = 0;
            loc = new Point(vOff, ya);
        }
        return loc;
    }

    static {
        _totalScreenDim = new Dimension(0, 0);
        log = LoggerFactory.getLogger(PlaceWindow.class);
    }
}

