/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortNameMapper {
    private static final HashMap<String, SerialPortFriendlyName> SERIAL_PORT_NAMES = new HashMap();
    private static boolean portsRetrieved = false;
    private static final Logger log = LoggerFactory.getLogger(PortNameMapper.class);

    private static synchronized void getWindowsSerialPortNames() {
        if (portsRetrieved) {
            return;
        }
        if (!SystemType.isWindows()) {
            portsRetrieved = true;
            return;
        }
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\FTDIBUS\\");
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\KEYSPAN\\");
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\USB\\");
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\HDAUDIO\\");
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\PCI\\");
        PortNameMapper.getDetailsFromWinRegistry("SYSTEM\\CurrentControlSet\\Enum\\ACPI\\");
        portsRetrieved = true;
    }

    private static void getDetailsFromWinRegistry(String path) {
        ArrayList<String> friendlyName = new ArrayList<String>();
        if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)path)) {
            return;
        }
        String[] regEntries = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)path);
        if (regEntries == null) {
            return;
        }
        for (String regEntry : regEntries) {
            String pathKey;
            String deviceClass;
            String[] subRegEntries = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)(path + regEntry));
            if (subRegEntries == null || subRegEntries.length <= 0) continue;
            String name = null;
            String port = null;
            TreeMap values = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)(path + regEntry + "\\" + subRegEntries[0]));
            if (values.containsKey("Class") && ((deviceClass = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)(pathKey = path + regEntry + "\\" + subRegEntries[0]), (String)"Class")).equals("Ports") || deviceClass.equals("Modem"))) {
                try {
                    name = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)pathKey, (String)"FriendlyName");
                }
                catch (Win32Exception | NullPointerException e) {
                    log.warn("'FriendlyName' not found while querying 'HKLM.{}`.  JMRI cannot use the device, so will skip it.", (Object)pathKey);
                }
                try {
                    String pathKey2 = path + regEntry + "\\" + subRegEntries[0] + "\\Device Parameters";
                    port = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)pathKey2, (String)"PortName");
                }
                catch (Win32Exception | NullPointerException throwable) {
                    // empty catch block
                }
            }
            if (name != null && port != null) {
                SERIAL_PORT_NAMES.put(port, new SerialPortFriendlyName(port, name));
                continue;
            }
            if (name == null) continue;
            friendlyName.add(name);
        }
        for (int i = 0; i < friendlyName.size(); ++i) {
            int commst = ((String)friendlyName.get(i)).lastIndexOf(40) + 1;
            int commls = ((String)friendlyName.get(i)).lastIndexOf(41);
            String commPort = ((String)friendlyName.get(i)).substring(commst, commls);
            SERIAL_PORT_NAMES.put(commPort, new SerialPortFriendlyName(commPort, (String)friendlyName.get(i)));
        }
    }

    public static String getPortFromName(String name) {
        if (!portsRetrieved) {
            PortNameMapper.getWindowsSerialPortNames();
        }
        for (Map.Entry<String, SerialPortFriendlyName> en : SERIAL_PORT_NAMES.entrySet()) {
            if (!en.getValue().getDisplayName().equals(name)) continue;
            return en.getKey();
        }
        return "";
    }

    public static HashMap<String, SerialPortFriendlyName> getPortNameMap() {
        if (!portsRetrieved) {
            PortNameMapper.getWindowsSerialPortNames();
        }
        return SERIAL_PORT_NAMES;
    }

    public static class SerialPortFriendlyName {
        String serialPortFriendly = "";
        boolean valid = false;

        public SerialPortFriendlyName(String port, String Friendly) {
            this.serialPortFriendly = Friendly;
            if (this.serialPortFriendly == null) {
                this.serialPortFriendly = port;
            } else if (!this.serialPortFriendly.contains(port)) {
                this.serialPortFriendly = Friendly + " (" + port + ")";
            }
        }

        public String getDisplayName() {
            return this.serialPortFriendly;
        }

        public boolean isValidPort() {
            return this.valid;
        }

        public void setValidPort(boolean boo) {
            this.valid = boo;
        }
    }
}

