/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jmri.util.Bundle;
import jmri.util.ValidatingInputPane;
import jmri.util.swing.JmriJOptionPane;

public class QuickPromptUtil {
    public static String promptForString(Component parentComponent, String message, String title, String oldValue) {
        String result = oldValue;
        String newValue = (String)JmriJOptionPane.showInputDialog(parentComponent, message, title, -1, null, null, oldValue);
        if (newValue != null) {
            result = newValue;
        }
        return result;
    }

    public static int promptForInt(Component parentComponent, String message, String title, int oldValue) {
        int result = oldValue;
        String newValue = QuickPromptUtil.promptForString(parentComponent, message, title, Integer.toString(oldValue));
        if (newValue != null) {
            try {
                result = Integer.parseInt(newValue);
            }
            catch (NumberFormatException e) {
                result = oldValue;
            }
        }
        return result;
    }

    public static Integer promptForInteger(Component parentComponent, @Nonnull String message, @Nonnull String title, Integer oldValue, @CheckForNull Predicate<Integer> validator) {
        Integer result = oldValue;
        Integer newValue = QuickPromptUtil.promptForData(parentComponent, message, title, oldValue, validator, val -> {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(Bundle.getMessage("InputDialogNotNumber"));
            }
        });
        if (newValue != null) {
            result = newValue;
        }
        return result;
    }

    private static <T> T promptForData(Component parentComponent, @Nonnull String message, @Nonnull String title, T oldValue, @CheckForNull Predicate<T> validator, @CheckForNull Function<String, T> converter) {
        T res;
        String result = oldValue == null ? "" : oldValue.toString();
        final JButton okOption = new JButton(Bundle.getMessage("ButtonOK"));
        final JButton cancelOption = new JButton(Bundle.getMessage("ButtonCancel"));
        okOption.setDefaultCapable(true);
        ValidatingInputPane<T> validating = new ValidatingInputPane<T>(converter).message(message).validator(validator).attachConfirmUI(okOption);
        validating.setText(result);
        JOptionPane pane = new JOptionPane(validating, -1, 2, null, new Object[]{okOption, cancelOption});
        pane.putClientProperty("OptionPane.buttonOrientation", 4);
        final JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.getRootPane().setDefaultButton(okOption);
        dialog.setResizable(true);
        class AL
        implements ActionListener {
            boolean confirmed;

            AL() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object s = e.getSource();
                if (s == okOption) {
                    this.confirmed = true;
                    dialog.setVisible(false);
                }
                if (s == cancelOption) {
                    dialog.setVisible(false);
                }
            }
        }
        AL al = new AL();
        okOption.addActionListener(al);
        cancelOption.addActionListener(al);
        dialog.setVisible(true);
        dialog.dispose();
        if (al.confirmed && (res = validating.getValue()) != null) {
            return res;
        }
        return oldValue;
    }

    public static float promptForFloat(Component parentComponent, String message, String title, float oldValue) {
        float result = oldValue;
        String newValue = QuickPromptUtil.promptForString(parentComponent, message, title, Float.toString(oldValue));
        if (newValue != null) {
            try {
                result = Float.parseFloat(newValue);
            }
            catch (NumberFormatException e) {
                result = oldValue;
            }
        }
        return result;
    }

    public static double promptForDouble(Component parentComponent, String message, String title, double oldValue) {
        double result = oldValue;
        String newValue = QuickPromptUtil.promptForString(parentComponent, message, title, Double.toString(oldValue));
        if (newValue != null) {
            try {
                result = Double.parseDouble(newValue);
            }
            catch (NumberFormatException e) {
                result = oldValue;
            }
        }
        return result;
    }

    public static Predicate<Integer> checkIntRange(Integer min, Integer max, String valueLabel) {
        return new IntRangePredicate(min, max, valueLabel);
    }

    static final class IntRangePredicate
    extends NumberRangePredicate<Integer> {
        public IntRangePredicate(Integer min, Integer max, String label) {
            super(min, max, label);
        }

        @Override
        protected boolean acceptLow(Integer val, Integer bound) {
            return val >= bound;
        }

        @Override
        protected boolean acceptHigh(Integer val, Integer bound) {
            return val <= bound;
        }
    }

    static final class FloatRangePredicate
    extends NumberRangePredicate<Float> {
        public FloatRangePredicate(Float min, Float max, String label) {
            super(min, max, label);
        }

        @Override
        protected boolean acceptLow(Float val, Float bound) {
            return val.floatValue() >= bound.floatValue();
        }

        @Override
        protected boolean acceptHigh(Float val, Float bound) {
            return val.floatValue() <= bound.floatValue();
        }
    }

    private static abstract class NumberRangePredicate<T extends Number>
    implements Predicate<T> {
        protected final T min;
        protected final T max;
        protected final String label;

        public NumberRangePredicate(T min, T max, String label) {
            this.min = min;
            this.max = max;
            this.label = label;
        }

        protected abstract boolean acceptLow(T var1, T var2);

        protected abstract boolean acceptHigh(T var1, T var2);

        @Override
        public boolean test(T t) {
            boolean ok = true;
            if (this.min != null && !this.acceptLow(t, this.min)) {
                ok = false;
            } else if (this.max != null && !this.acceptHigh(t, this.max)) {
                ok = false;
            }
            if (ok) {
                return true;
            }
            String msgKey = this.label != null ? (this.min == null ? "NumberCheckOutOfRangeMax" : (this.max == null ? "NumberCheckOutOfRangeMin" : "NumberCheckOutOfRangeBoth")) : (this.min == null ? "NumberCheckOutOfRangeMax2" : (this.max == null ? "NumberCheckOutOfRangeMin2" : "NumberCheckOutOfRangeBoth2"));
            throw new IllegalArgumentException(Bundle.getMessage(msgKey, this.label, this.min, this.max));
        }
    }
}

