/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    public static final String HTML_CLOSE_TAG = "</html>";
    public static final String HTML_OPEN_TAG = "<html>";
    public static final String LINEBREAK = "\n";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);

    private StringUtil() {
    }

    @CheckReturnValue
    public static int getStateFromName(String name, @Nonnull int[] states, @Nonnull String[] names) {
        for (int i = 0; i < states.length; ++i) {
            if (!name.equals(names[i])) continue;
            return states[i];
        }
        return -1;
    }

    @Nonnull
    @CheckReturnValue
    public static String[] getNamesFromStateMasked(int state, @Nonnull int[] states, @Nonnull int[] masks, @Nonnull String[] names) {
        int count = 0;
        String[] temp = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            if (((state ^ states[i]) & masks[i]) != 0) continue;
            temp[count++] = names[i];
        }
        String[] output = new String[count];
        System.arraycopy(temp, 0, output, 0, count);
        return output;
    }

    @CheckReturnValue
    @CheckForNull
    public static String getNameFromState(int state, @Nonnull int[] states, @Nonnull String[] names) {
        for (int i = 0; i < states.length; ++i) {
            if (state != states[i]) continue;
            return names[i];
        }
        return null;
    }

    @Nonnull
    @CheckReturnValue
    public static String[] getNamesFromState(int state, @Nonnull int[] states, @Nonnull String[] names) {
        int count = 0;
        String[] temp = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            if ((state != 0 || states[i] != 0) && (state & states[i]) == 0) continue;
            temp[count] = names[i];
            ++count;
        }
        String[] output = new String[count];
        System.arraycopy(temp, 0, output, 0, count);
        return output;
    }

    @CheckReturnValue
    @Nonnull
    public static String twoHexFromInt(int val) {
        StringBuilder sb = new StringBuilder();
        sb.append(HEX_CHARS[(val & 0xF0) >> 4]);
        sb.append(HEX_CHARS[val & 0xF]);
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String appendTwoHexFromInt(int val, @Nonnull String inString) {
        StringBuilder sb = new StringBuilder(inString);
        sb.append(StringUtil.twoHexFromInt(val));
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String to8Bits(int val, boolean msbLeft) {
        StringBuilder result = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            if (msbLeft) {
                result.insert(0, (val & 1) != 0 ? "1" : "0");
            } else {
                result.append((val & 1) != 0 ? "1" : "0");
            }
            val >>= 1;
        }
        return result.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String hexStringFromBytes(@Nonnull byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(HEX_CHARS[(aByte & 0xF0) >> 4]);
            sb.append(HEX_CHARS[aByte & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String hexStringFromInts(@Nonnull int[] v) {
        StringBuilder retval = new StringBuilder();
        for (int e : v) {
            retval.append(StringUtil.twoHexFromInt(e));
            retval.append(" ");
        }
        return retval.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static byte[] bytesFromHexString(@Nonnull String s) {
        String ts = s + "  ";
        int len = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (ts.charAt(i) == ' ') continue;
            if (ts.charAt(i + 1) != ' ') {
                ++i;
                ++len;
                continue;
            }
            ++len;
        }
        byte[] b = new byte[len];
        int saveAt = 0;
        for (int i = 0; i < s.length(); ++i) {
            String v;
            if (ts.charAt(i) == ' ') continue;
            if (ts.charAt(i + 1) != ' ') {
                v = "" + ts.charAt(i) + ts.charAt(i + 1);
                b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
                ++i;
                ++saveAt;
                continue;
            }
            v = "" + ts.charAt(i);
            b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
            ++saveAt;
        }
        return b;
    }

    @Nonnull
    public static int[] intBytesWithTotalFromNonSpacedHexString(@Nonnull String s, boolean headerTotal) {
        if (s.length() % 2 == 0) {
            int numBytes = s.length() / 2;
            if (headerTotal) {
                int[] arr = new int[numBytes + 1];
                arr[0] = numBytes;
                for (int i = 0; i < numBytes; ++i) {
                    arr[i + 1] = StringUtil.getByte(i, s);
                }
                return arr;
            }
            int[] arr = new int[numBytes];
            for (int i = 0; i < numBytes; ++i) {
                arr[i] = StringUtil.getByte(i, s);
            }
            return arr;
        }
        return new int[]{0};
    }

    public static int getHexDigit(int index, @Nonnull String byteString) {
        int b = byteString.charAt(index);
        b = b >= 48 && b <= 57 ? (b -= 48) : (b >= 65 && b <= 70 ? b - 65 + 10 : (b >= 97 && b <= 102 ? b - 97 + 10 : 0));
        return (byte)b;
    }

    public static int getByte(int b, @Nonnull String byteString) {
        if (b >= 0) {
            int index = b * 2;
            int hi = StringUtil.getHexDigit(index++, byteString);
            int lo = StringUtil.getHexDigit(index, byteString);
            if (hi < 16 && lo < 16) {
                return hi * 16 + lo;
            }
        }
        return 0;
    }

    @CheckReturnValue
    @Nonnull
    public static byte[] fullTextToHexArray(@Nonnull String s, int numBytes) {
        byte[] b = new byte[numBytes];
        Arrays.fill(b, (byte)32);
        s = s.substring(0, Math.min(s.length(), numBytes));
        String convrtedNoSpaces = String.format("%x", new BigInteger(1, s.getBytes()));
        int byteNum = 0;
        for (int i = 0; i < convrtedNoSpaces.length(); i += 2) {
            b[byteNum] = (byte)Integer.parseInt(convrtedNoSpaces.substring(i, i + 2), 16);
            ++byteNum;
        }
        return b;
    }

    public static void sortUpperCase(@Nonnull Object[] values) {
        Arrays.sort(values, (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
    }

    public static void numberSort(@Nonnull String[] values) throws NumberFormatException {
        for (int i = 0; i <= values.length - 2; ++i) {
            for (int j = values.length - 2; j >= i; --j) {
                if (Integer.parseInt(values[j]) <= Integer.parseInt(values[j + 1])) continue;
                String temp = values[j];
                values[j] = values[j + 1];
                values[j + 1] = temp;
            }
        }
    }

    @CheckReturnValue
    @CheckForNull
    public static String parenQuote(@CheckForNull String in) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        StringBuilder result = new StringBuilder();
        int level = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '(': {
                    ++level;
                    break;
                }
                case '\\': {
                    result.append('\\');
                    break;
                }
                case ')': {
                    if (--level >= 0) break;
                    level = 0;
                    result.append('\\');
                    break;
                }
            }
            result.append(c);
        }
        return new String(result);
    }

    @CheckReturnValue
    @CheckForNull
    static String parenUnQuote(@CheckForNull String in) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\\' && (c = in.charAt(++i)) != '\\' && c != ')') {
                c = (char)(c + 92);
            }
            result.append(c);
        }
        return new String(result);
    }

    @CheckReturnValue
    @Nonnull
    public static List<String> splitParens(@CheckForNull String in) {
        ArrayList<String> result = new ArrayList<String>();
        if (in == null || in.isEmpty()) {
            return result;
        }
        int level = 0;
        Object temp = "";
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '(': {
                    ++level;
                    break;
                }
                case '\\': {
                    temp = (String)temp + c;
                    c = in.charAt(++i);
                    break;
                }
                case ')': {
                    --level;
                    break;
                }
            }
            temp = (String)temp + c;
            if (level != 0) continue;
            result.add((String)temp);
            temp = "";
        }
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public static <E> String arrayToString(@Nonnull E[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        for (E e : v) {
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e.toString());
            retval.append(']');
        }
        return new String(retval);
    }

    @CheckReturnValue
    @Nonnull
    public static String arrayToString(@Nonnull byte[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        for (byte e : v) {
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e);
            retval.append(']');
        }
        return new String(retval);
    }

    @CheckReturnValue
    @Nonnull
    public static String arrayToString(@Nonnull int[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        for (int e : v) {
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e);
            retval.append(']');
        }
        return new String(retval);
    }

    @CheckReturnValue
    public static String padString(@Nonnull String value, int length) {
        if (length > 1) {
            return String.format("%-" + length + "s", value.substring(0, Math.min(value.length(), length - 1)));
        }
        return value;
    }

    @CheckReturnValue
    public static int getFirstIntFromString(@Nonnull String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != ' ') {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (sb.length() <= 0) continue;
                break;
            }
            if (sb.length() > 0) break;
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    @CheckReturnValue
    public static int getLastIntFromString(@Nonnull String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c != ' ') {
                if (Character.isDigit(c)) {
                    sb.insert(0, c);
                    continue;
                }
                if (sb.length() <= 0) continue;
                break;
            }
            if (sb.length() > 0) break;
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    @CheckForNull
    public static String incrementLastNumberInString(@Nonnull String str, int increment) {
        int num = StringUtil.getLastIntFromString(str);
        return num == -1 ? null : StringUtil.replaceLast(str, String.valueOf(num), String.valueOf(num + increment));
    }

    @CheckReturnValue
    @Nonnull
    public static String replaceLast(@Nonnull String string, @Nonnull String from, @Nonnull String to) {
        int lastIndex = string.lastIndexOf(from);
        if (lastIndex < 0) {
            return string;
        }
        String tail = string.substring(lastIndex).replaceFirst(from, to);
        return string.substring(0, lastIndex) + tail;
    }

    public static String concatTextHtmlAware(String baseText, String extraText) {
        if (baseText == null && extraText == null) {
            return null;
        }
        if (baseText == null) {
            return extraText;
        }
        if (extraText == null) {
            return baseText;
        }
        boolean hasHtml = false;
        Object result = baseText + extraText;
        result = ((String)result).replaceAll("(?i)<html>", "");
        if (!((String)(result = ((String)result).replaceAll("(?i)</html>", ""))).equals(baseText + extraText)) {
            hasHtml = true;
            log.debug("\n\nbaseText:\n\"{}\"\nextraText:\n\"{}\"\n", (Object)baseText, (Object)extraText);
        }
        if (hasHtml) {
            result = HTML_OPEN_TAG + (String)result + HTML_CLOSE_TAG;
            log.debug("\nCombined String:\n\"{}\"\n", result);
        }
        return result;
    }

    public static String stripHtmlTags(String originalText) {
        String replaceA = originalText.replace("<br>", System.lineSeparator());
        String replaceB = replaceA.replace("<br/>", System.lineSeparator());
        String replaceC = replaceB.replace("<br />", System.lineSeparator());
        String regex = "<[^>]*>";
        Matcher matcher = Pattern.compile(regex).matcher(replaceC);
        return matcher.replaceAll("");
    }
}

