/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jmri.JmriException;
import jmri.Reference;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ThreadingUtil {
    private static boolean lastWarnLocksLimit = false;
    private static RuntimeException lastWarnLocksException = null;
    private static final Logger log = LoggerFactory.getLogger(ThreadingUtil.class);

    public static void runOnLayout(@Nonnull ThreadAction ta) {
        ThreadingUtil.runOnGUI(ta);
    }

    public static void runOnLayoutWithJmriException(@Nonnull ThreadActionWithJmriException ta) throws JmriException, RuntimeException {
        ThreadingUtil.runOnGUIWithJmriException(ta);
    }

    public static void runOnLayoutEventually(@Nonnull ThreadAction ta) {
        ThreadingUtil.runOnGUIEventually(ta);
    }

    @Nonnull
    public static Timer runOnLayoutDelayed(@Nonnull ThreadAction ta, int delay) {
        return ThreadingUtil.runOnGUIDelayed(ta, delay);
    }

    public static boolean isLayoutThread() {
        return ThreadingUtil.isGUIThread();
    }

    public static void runOnGUI(@Nonnull ThreadAction ta) {
        if (ThreadingUtil.isGUIThread()) {
            ta.run();
        } else {
            ThreadingUtil.warnLocks();
            try {
                SwingUtilities.invokeAndWait(ta);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted while running on GUI thread");
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                log.error("Error while on GUI thread", e.getCause());
                log.error("   Came from call to runOnGUI:", (Throwable)e);
            }
        }
    }

    public static void runOnGUIWithJmriException(@Nonnull ThreadActionWithJmriException ta) throws JmriException, RuntimeException {
        if (ThreadingUtil.isGUIThread()) {
            ta.run();
        } else {
            ThreadingUtil.warnLocks();
            try {
                Reference jmriException = new Reference();
                Reference runtimeException = new Reference();
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        ta.run();
                    }
                    catch (JmriException e) {
                        jmriException.set(e);
                    }
                    catch (RuntimeException e) {
                        runtimeException.set(e);
                    }
                });
                JmriException je = (JmriException)jmriException.get();
                if (je != null) {
                    throw je;
                }
                RuntimeException re = (RuntimeException)runtimeException.get();
                if (re != null) {
                    throw re;
                }
            }
            catch (InterruptedException e) {
                log.debug("Interrupted while running on GUI thread");
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                log.error("Error while on GUI thread", e.getCause());
                log.error("   Came from call to runOnGUI:", (Throwable)e);
            }
        }
    }

    public static <E> E runOnGUIwithReturn(@Nonnull ReturningThreadAction<E> ta) {
        if (ThreadingUtil.isGUIThread()) {
            return ta.run();
        }
        ThreadingUtil.warnLocks();
        Reference result = new Reference();
        try {
            SwingUtilities.invokeAndWait(() -> result.set(ta.run()));
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while running on GUI thread");
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            log.error("Error while on GUI thread", e.getCause());
            log.error("   Came from call to runOnGUIwithReturn:", (Throwable)e);
        }
        return result.get();
    }

    public static void runOnGUIEventually(@Nonnull ThreadAction ta) {
        SwingUtilities.invokeLater(ta);
    }

    @Nonnull
    public static Timer runOnGUIDelayed(@Nonnull ThreadAction ta, int delay) {
        Timer timer = new Timer(delay, e -> ta.run());
        timer.setRepeats(false);
        timer.start();
        return timer;
    }

    public static boolean isGUIThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static Thread newThread(Runnable runner) {
        return new Thread(ThreadingUtil.getJmriThreadGroup(), runner);
    }

    public static Thread newThread(Runnable runner, String name) {
        return new Thread(ThreadingUtil.getJmriThreadGroup(), runner, name);
    }

    public static ThreadGroup getJmriThreadGroup() {
        ThreadGroup main = Thread.currentThread().getThreadGroup();
        while (main.getParent() != null) {
            main = main.getParent();
        }
        ThreadGroup[] list = new ThreadGroup[main.activeGroupCount() + 2];
        int max = main.enumerate(list);
        for (int i = 0; i < max; ++i) {
            if (!list[i].getName().equals("JMRI")) continue;
            return list[i];
        }
        return new ThreadGroup(main, "JMRI");
    }

    public static boolean canThreadRun(@Nonnull Thread t) {
        Thread.State s = t.getState();
        return s.equals((Object)Thread.State.RUNNABLE);
    }

    public static boolean isThreadWaiting(@Nonnull Thread t) {
        Thread.State s = t.getState();
        return s.equals((Object)Thread.State.BLOCKED) || s.equals((Object)Thread.State.WAITING) || s.equals((Object)Thread.State.TIMED_WAITING);
    }

    public static void requireGuiThread(Logger logger) {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(logger, "Call not on GUI thread", new Exception("traceback"));
        }
    }

    public static void requireLayoutThread(Logger logger) {
        if (!ThreadingUtil.isLayoutThread()) {
            LoggingUtil.warnOnce(logger, "Call not on Layout thread", new Exception("traceback"));
        }
    }

    public static void warnLocks() {
        if (log.isDebugEnabled()) {
            try {
                LockInfo[] locks;
                MonitorInfo[] monitors;
                ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{Thread.currentThread().getId()}, true, true)[0];
                for (MonitorInfo mon : monitors = threadInfo.getLockedMonitors()) {
                    log.warn("Thread was holding monitor {} from {}", new Object[]{mon, mon.getLockedStackFrame(), LoggingUtil.shortenStacktrace(new Exception("traceback"))});
                }
                for (LockInfo lock : locks = threadInfo.getLockedSynchronizers()) {
                    if (lock.toString().startsWith("java.util.concurrent.ThreadPoolExecutor$Worker")) {
                        log.debug("Thread was holding java lock {}", (Object)lock, (Object)LoggingUtil.shortenStacktrace(new Exception("traceback")));
                        continue;
                    }
                    log.warn("Thread was holding lock {}", (Object)lock, (Object)LoggingUtil.shortenStacktrace(new Exception("traceback")));
                }
            }
            catch (RuntimeException ex) {
                if (!lastWarnLocksLimit) {
                    log.warn("Exception in warnLocks", (Throwable)ex);
                }
                lastWarnLocksLimit = true;
                lastWarnLocksException = ex;
            }
        }
    }

    public RuntimeException getlastWarnLocksException() {
        return lastWarnLocksException;
    }

    @FunctionalInterface
    public static interface ReturningThreadAction<E> {
        public E run();
    }

    @FunctionalInterface
    public static interface ThreadActionWithJmriException {
        public void run() throws JmriException, RuntimeException;
    }

    @FunctionalInterface
    public static interface ThreadAction
    extends Runnable {
        @Override
        public void run();
    }
}

