/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TimerUtil {
    static final Timer commonTimer = new Timer("JMRI Common Timer", true);
    private static final Logger log = LoggerFactory.getLogger(TimerUtil.class);

    private TimerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(@Nonnull TimerTask task, @Nonnull Date time) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, time);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(@Nonnull TimerTask task, long delay) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, delay);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRate(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRate(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(task, delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    private static TimerTask gtask(final TimerTask task) {
        return new TimerTask(){

            @Override
            public void run() {
                ThreadingUtil.runOnGUIEventually(() -> task.run());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnGUIThread(@Nonnull TimerTask task, @Nonnull Date time) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), time);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnGUIThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnGUIThread(@Nonnull TimerTask task, long delay) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), delay);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnGUIThread(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRateOnGUIThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRateOnGUIThread(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.gtask(task), delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    private static TimerTask ltask(final TimerTask task) {
        return new TimerTask(){

            @Override
            public void run() {
                ThreadingUtil.runOnLayoutEventually(() -> task.run());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date time) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), time);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, long delay) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), delay);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRateOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), firstTime, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleAtFixedRateOnLayoutThread(@Nonnull TimerTask task, long delay, long period) {
        Timer timer = commonTimer;
        synchronized (timer) {
            try {
                commonTimer.schedule(TimerUtil.ltask(task), delay, period);
            }
            catch (IllegalStateException e) {
                log.warn("During schedule()", (Throwable)e);
            }
        }
    }
}

