/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Reportable;
import jmri.util.IntlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeConversionUtil {
    private static final Logger log = LoggerFactory.getLogger(TypeConversionUtil.class);

    public static boolean isIntegerNumber(Object object) {
        return object instanceof AtomicInteger || object instanceof AtomicLong || object instanceof BigInteger || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long;
    }

    public static boolean isFloatingNumber(Object object) {
        return TypeConversionUtil.isIntegerNumber(object) || object instanceof BigDecimal || object instanceof Float || object instanceof Double;
    }

    public static boolean isString(Object object) {
        return object instanceof String;
    }

    public static boolean convertToBoolean(@CheckForNull Object value, boolean do_i18n) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof TextNode) {
            value = ((TextNode)value).asText();
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        try {
            value = TypeConversionUtil.convertToLong(value, true, true, false);
        }
        catch (NumberFormatException e) {
            try {
                value = TypeConversionUtil.convertToDouble(value, do_i18n, true, true, false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            return !(-0.5 < number) || !(number < 0.5);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        switch (value.toString().toLowerCase()) {
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" can't be converted to a boolean", value));
    }

    private static boolean convertStringToBoolean_JythonRules(@Nonnull String str, boolean do_i18n) {
        try {
            double number = do_i18n ? IntlUtilities.doubleValue(str) : Double.parseDouble(str);
            return !(-0.5 < number) || !(number < 0.5);
        }
        catch (NumberFormatException | ParseException ex) {
            log.debug("The string '{}' cannot be parsed as a number", (Object)str);
            String patternString = "^0(\\.0+)?$";
            Pattern pattern = Pattern.compile(patternString, 2);
            Matcher matcher = pattern.matcher(str);
            if (matcher.matches()) {
                return false;
            }
            return !str.isEmpty();
        }
    }

    public static boolean convertToBoolean_JythonRules(@CheckForNull Object value, boolean do_i18n) {
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return !map.isEmpty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return !collection.isEmpty();
        }
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            return array.length > 0;
        }
        if (value instanceof TextNode) {
            value = ((TextNode)value).asText();
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            return !(-0.5 < number) || !(number < 0.5);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return false;
        }
        return TypeConversionUtil.convertStringToBoolean_JythonRules(value.toString(), do_i18n);
    }

    private static long convertStringToLong(@Nonnull String str, boolean checkAll, boolean throwOnError, boolean warnOnError) {
        Pattern pattern;
        Matcher matcher;
        Object patternString = "^(\\-?\\d+)";
        if (checkAll) {
            patternString = (String)patternString + "$";
        }
        if ((matcher = (pattern = Pattern.compile((String)patternString, 2)).matcher(str)).lookingAt()) {
            String theNumber = matcher.group(1);
            long number = Long.parseLong(theNumber);
            log.debug("the string {} is converted to the number {}", (Object)str, (Object)number);
            return number;
        }
        if (warnOnError) {
            log.warn("the string \"{}\" cannot be converted to a number", (Object)str);
        }
        if (throwOnError) {
            throw new NumberFormatException(String.format("the string \"%s\" cannot be converted to a number", str));
        }
        return 0L;
    }

    public static long convertToLong(@CheckForNull Object value) {
        return TypeConversionUtil.convertToLong(value, false, false);
    }

    public static long convertToLong(@CheckForNull Object value, boolean checkAll, boolean throwOnError) {
        return TypeConversionUtil.convertToLong(value, checkAll, throwOnError, true);
    }

    public static long convertToLong(@CheckForNull Object value, boolean checkAll, boolean throwOnError, boolean warnOnError) throws NumberFormatException {
        if (value == null) {
            log.warn("the object is null and the returned number is therefore 0.0");
            return 0L;
        }
        if (value instanceof TextNode) {
            value = ((TextNode)value).asText();
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            if (!(value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || !throwOnError)) {
                throw new NumberFormatException(String.format("the value %s cannot be converted to an integer", value));
            }
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            if (throwOnError) {
                throw new NumberFormatException(String.format("the boolean value \"%b\" cannot be converted to an integer", (Boolean)value));
            }
            return Boolean.TRUE.equals(value) ? 1L : 0L;
        }
        if (value == null) {
            if (throwOnError) {
                throw new NumberFormatException("the null value cannot be converted to an integer");
            }
            return 0L;
        }
        return TypeConversionUtil.convertStringToLong(value.toString(), checkAll, throwOnError, warnOnError);
    }

    private static double convertStringToDouble(@Nonnull String str, boolean checkAll, boolean throwOnError, boolean warnOnError) {
        Pattern pattern;
        Matcher matcher;
        Object patternString = "^(\\-?\\d+(\\.\\d+)?(e\\-?\\d+)?)";
        if (checkAll) {
            patternString = (String)patternString + "$";
        }
        if ((matcher = (pattern = Pattern.compile((String)patternString, 2)).matcher(str)).lookingAt()) {
            String theNumber = matcher.group(1);
            double number = Double.parseDouble(theNumber);
            log.debug("the string {} is converted to the number {}", (Object)str, (Object)number);
            return number;
        }
        if (warnOnError) {
            log.warn("the string \"{}\" cannot be converted to a number", (Object)str);
        }
        if (throwOnError) {
            throw new NumberFormatException(String.format("the string \"%s\" cannot be converted to a number", str));
        }
        return 0.0;
    }

    public static double convertToDouble(@CheckForNull Object value, boolean do_i18n) {
        return TypeConversionUtil.convertToDouble(value, do_i18n, false, false);
    }

    public static double convertToDouble(@CheckForNull Object value, boolean do_i18n, boolean checkAll, boolean throwOnError) {
        return TypeConversionUtil.convertToDouble(value, do_i18n, checkAll, throwOnError, true);
    }

    public static double convertToDouble(@CheckForNull Object value, boolean do_i18n, boolean checkAll, boolean throwOnError, boolean warnOnError) {
        if (value == null) {
            log.warn("the object is null and the returned number is therefore 0.0");
            return 0.0;
        }
        if (value instanceof TextNode) {
            value = ((TextNode)value).asText();
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            if (throwOnError) {
                throw new NumberFormatException(String.format("the boolean value \"%b\" cannot be converted to a number", (Boolean)value));
            }
            return Boolean.TRUE.equals(value) ? 1.0 : 0.0;
        }
        if (value == null) {
            if (throwOnError) {
                throw new NumberFormatException("the null value cannot be converted to a number");
            }
            return 0.0;
        }
        if (do_i18n) {
            try {
                double number = IntlUtilities.doubleValue(value.toString());
                return number;
            }
            catch (ParseException ex) {
                log.debug("The string '{}' cannot be parsed as a number", value);
            }
        }
        return TypeConversionUtil.convertStringToDouble(value.toString(), checkAll, throwOnError, warnOnError);
    }

    @Nonnull
    public static String convertToString(@CheckForNull Object value, boolean do_i18n) {
        if (value == null) {
            return "";
        }
        if (value instanceof TextNode) {
            return ((TextNode)value).asText();
        }
        if (value instanceof Reportable) {
            return ((Reportable)value).toReportString();
        }
        if (value instanceof Number && do_i18n) {
            return IntlUtilities.valueOf(((Number)value).doubleValue());
        }
        return value.toString();
    }
}

