/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipFileClass {
    private static final Logger log = LoggerFactory.getLogger(UnzipFileClass.class);

    public static void unzipFunction(String destinationFolder, String zipFile) throws FileNotFoundException {
        File directory = new File(destinationFolder);
        FileInputStream fInput = new FileInputStream(zipFile);
        UnzipFileClass.unzipFunction(directory, fInput);
    }

    public static void unzipFunction(File directory, InputStream input) {
        if (!directory.exists() && !directory.mkdirs()) {
            log.error("Unable to create output directory {}", (Object)directory);
        }
        String destinationFolder = directory.getPath();
        byte[] buffer = new byte[2048];
        try {
            ZipInputStream zipInput = new ZipInputStream(input);
            try {
                ZipEntry entry = zipInput.getNextEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    File file = new File(destinationFolder + File.separator + entryName);
                    log.info("Unzip file {} to {}", (Object)entryName, (Object)file.getAbsolutePath());
                    if (entry.isDirectory()) {
                        boolean success;
                        File newDir = new File(file.getAbsolutePath());
                        if (!newDir.exists() && !(success = newDir.mkdirs())) {
                            log.error("Problem creating Folder {}", (Object)newDir);
                        }
                    } else {
                        try (FileOutputStream fOutput = new FileOutputStream(file);){
                            int count = 0;
                            while ((count = zipInput.read(buffer)) > 0) {
                                fOutput.write(buffer, 0, count);
                            }
                        }
                        catch (IOException e) {
                            log.error("Error writing unpacked zip file contents", (Throwable)e);
                            zipInput.close();
                            return;
                        }
                    }
                    zipInput.closeEntry();
                    entry = zipInput.getNextEntry();
                }
                zipInput.closeEntry();
                zipInput.close();
                input.close();
            }
            finally {
                try {
                    zipInput.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            log.error("Error unpacking zip file", (Throwable)e);
        }
    }
}

