/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jmri.util.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.WindowInterface;

public class WindowMenu
extends JMenu
implements MenuListener {
    private Frame parentFrame;
    private List<JmriJFrame> framesList;

    public WindowMenu(WindowInterface wi) {
        super(Bundle.getMessage("MenuWindow"));
        this.parentFrame = wi.getFrame();
        this.addMenuListener(this);
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.framesList = JmriJFrame.getFrameList();
        this.removeAll();
        this.add(new AbstractAction(Bundle.getMessage("ButtonClose")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowMenu.this.parentFrame != null) {
                    WindowMenu.this.parentFrame.dispatchEvent(new WindowEvent(WindowMenu.this.parentFrame, 201));
                }
            }
        });
        this.add(new AbstractAction(Bundle.getMessage("MenuItemMinimize")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowMenu.this.parentFrame != null) {
                    WindowMenu.this.parentFrame.setState(1);
                }
            }
        });
        this.add(new JSeparator());
        int framesNumber = this.framesList.size();
        for (int i = 0; i < framesNumber; ++i) {
            JmriJFrame iFrame = this.framesList.get(i);
            String windowName = iFrame.getTitle();
            if (windowName.equals("")) {
                windowName = "Untitled";
            }
            JCheckBoxMenuItem newItem = new JCheckBoxMenuItem(new AbstractAction(windowName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int firstItem;
                    JMenuItem selectedItem = (JMenuItem)e.getSource();
                    int itemCount = WindowMenu.this.getItemCount();
                    for (int i = firstItem = itemCount - WindowMenu.this.framesList.size(); i < itemCount; ++i) {
                        if (selectedItem != WindowMenu.this.getItem(i) || (i -= firstItem) >= WindowMenu.this.framesList.size()) continue;
                        WindowMenu.this.framesList.get(i).setVisible(true);
                        WindowMenu.this.framesList.get(i).setExtendedState(0);
                        return;
                    }
                }
            });
            if (iFrame == this.parentFrame) {
                newItem.setState(true);
            }
            this.add(newItem);
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

