/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.com.rbnb;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPInputStream
extends InputStream {
    private static final int PACKET_BUFFER_SIZE = 5000;
    DatagramSocket dsock = null;
    DatagramPacket dpack = null;
    byte[] ddata = new byte[5000];
    int packSize = 0;
    int packIdx = 0;
    int value;

    public UDPInputStream() {
    }

    public UDPInputStream(String address, int port) throws UnknownHostException, SocketException {
        this.open(address, port);
    }

    public void open(String address, int port) throws UnknownHostException, SocketException {
        this.dsock = address != null ? new DatagramSocket(port, InetAddress.getByName(address)) : new DatagramSocket(port);
    }

    @Override
    public void close() throws IOException {
        this.dsock.close();
        this.dsock = null;
        this.ddata = null;
        this.packSize = 0;
        this.packIdx = 0;
    }

    @Override
    public int available() throws IOException {
        return this.packSize - this.packIdx;
    }

    @Override
    public int read() throws IOException {
        if (this.packIdx == this.packSize) {
            this.receive();
        }
        this.value = this.ddata[this.packIdx] & 0xFF;
        ++this.packIdx;
        return this.value;
    }

    @Override
    public int read(byte[] buff) throws IOException {
        return this.read(buff, 0, buff.length);
    }

    @Override
    public int read(byte[] buff, int off, int len) throws IOException {
        int lenRemaining;
        if (this.packIdx == this.packSize) {
            this.receive();
        }
        for (lenRemaining = len; this.available() < lenRemaining; lenRemaining -= this.available()) {
            System.arraycopy(this.ddata, this.packIdx, buff, off + (len - lenRemaining), this.available());
            this.receive();
        }
        System.arraycopy(this.ddata, this.packIdx, buff, off + (len - lenRemaining), lenRemaining);
        this.packIdx += lenRemaining;
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        long lenRemaining;
        if (this.packIdx == this.packSize) {
            this.receive();
        }
        for (lenRemaining = len; (long)this.available() < lenRemaining; lenRemaining -= (long)this.available()) {
            this.receive();
        }
        this.packIdx += (int)lenRemaining;
        return len;
    }

    private void receive() throws IOException {
        this.dpack = new DatagramPacket(this.ddata, 5000);
        this.dsock.receive(this.dpack);
        this.packIdx = 0;
        this.packSize = this.dpack.getLength();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Marks are not supported by UDPInputStream.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

