/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.com.rbnb;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 8192;
    protected DatagramSocket dsock = null;
    DatagramPacket dpack = null;
    InetAddress iAdd = null;
    int port = 0;
    byte[] buffer = new byte[1024];
    byte[] outdata = null;
    int idx = 0;
    int bufferMax = 8192;

    public UDPOutputStream() {
    }

    public UDPOutputStream(int buffSize) {
        this.setBufferSize(buffSize);
    }

    public UDPOutputStream(String address, int portI) throws UnknownHostException, SocketException, IOException {
        this.open(InetAddress.getByName(address), portI);
    }

    public UDPOutputStream(InetAddress address, int portI) throws SocketException, IOException {
        this.open(address, portI);
    }

    public UDPOutputStream(String address, int portI, int buffSize) throws UnknownHostException, SocketException, IOException {
        this.open(InetAddress.getByName(address), portI);
        this.setBufferSize(buffSize);
    }

    public UDPOutputStream(InetAddress address, int portI, int buffSize) throws SocketException, IOException {
        this.open(address, portI);
        this.setBufferSize(buffSize);
    }

    public void open(InetAddress address, int portI) throws SocketException, IOException {
        this.dsock = new DatagramSocket();
        this.iAdd = address;
        this.port = portI;
    }

    @Override
    public void close() throws IOException {
        this.dsock.close();
        this.dsock = null;
        this.idx = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.idx == 0) {
            return;
        }
        if (this.idx == this.buffer.length) {
            this.outdata = this.buffer;
        } else {
            this.outdata = new byte[this.idx];
            System.arraycopy(this.buffer, 0, this.outdata, 0, this.idx);
        }
        this.dpack = new DatagramPacket(this.outdata, this.idx, this.iAdd, this.port);
        this.dsock.send(this.dpack);
        this.idx = 0;
    }

    @Override
    public void write(int value) throws IOException {
        this.buffer[this.idx] = (byte)(value & 0xFF);
        ++this.idx;
        if (this.idx >= this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        int lenRemaining;
        try {
            for (lenRemaining = len; this.buffer.length - this.idx <= lenRemaining; lenRemaining -= this.buffer.length - this.idx) {
                System.arraycopy(data, off + (len - lenRemaining), this.buffer, this.idx, this.buffer.length - this.idx);
                this.idx = this.buffer.length;
                this.flush();
            }
            if (lenRemaining == 0) {
                return;
            }
            System.arraycopy(data, off + (len - lenRemaining), this.buffer, this.idx, lenRemaining);
            this.idx += lenRemaining;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("len: " + len);
            System.err.println("lenRemaining: " + lenRemaining);
            System.err.println("idx: " + this.idx);
            System.err.println("buffer.length: " + this.buffer.length);
            System.err.println("offset: " + off);
            System.err.println("data.length: " + data.length);
            throw e;
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void setMaxBufferSize(int max) {
        this.bufferMax = max;
    }

    public void setBufferSize(int buffSize) {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (buffSize == this.buffer.length) {
            return;
        }
        this.buffer = buffSize > 0 ? (buffSize > this.bufferMax ? new byte[this.bufferMax] : new byte[buffSize]) : new byte[1];
    }
}

