/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.docbook.configurexml;

import java.util.ArrayList;
import java.util.List;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.util.docbook.RevHistory;
import jmri.util.docbook.Revision;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RevHistoryXml
extends AbstractXmlAdapter {
    private static final String NAMESPACE = "http://docbook.org/ns/docbook";

    @Override
    public boolean load(Element shared, Element perNode) {
        return true;
    }

    public static RevHistory loadRevHistory(Element e) {
        RevHistory r = new RevHistory();
        List list = e.getChildren("revision", Namespace.getNamespace((String)NAMESPACE));
        for (int i = 0; i < list.size(); ++i) {
            RevHistoryXml.loadRevision(r, (Element)list.get(i));
        }
        return r;
    }

    static void loadRevision(RevHistory r, Element e) {
        Namespace n = Namespace.getNamespace((String)NAMESPACE);
        int revnumber = 0;
        Element s = e.getChild("revnumber", n);
        if (s != null) {
            String c = s.getText();
            revnumber = Integer.parseInt(c);
        }
        String date = null;
        s = e.getChild("date", n);
        if (s != null) {
            date = s.getText();
        }
        String authorinitials = null;
        s = e.getChild("authorinitials", n);
        if (s != null) {
            authorinitials = s.getText();
        }
        String revremark = null;
        s = e.getChild("revremark", n);
        if (s != null) {
            revremark = s.getText();
        }
        r.addRevision(revnumber, date, authorinitials, revremark);
    }

    @Override
    public void load(Element e, Object o) {
        throw new UnsupportedOperationException("Method not coded");
    }

    @Override
    public Element store(Object o) {
        return RevHistoryXml.storeDirectly(o);
    }

    public static Element storeDirectly(Object o) {
        RevHistory r = (RevHistory)o;
        if (r == null) {
            return null;
        }
        Element e = RevHistoryXml.historyElement(r);
        return e;
    }

    static Element historyElement(RevHistory r) {
        ArrayList<Revision> list = r.getList();
        Element e = new Element("revhistory", NAMESPACE);
        for (int i = 0; i < list.size(); ++i) {
            Element revision = RevHistoryXml.revisionElement(list.get(i));
            e.addContent((Content)revision);
        }
        return e;
    }

    static Element revisionElement(Revision r) {
        Element rev = new Element("revision", NAMESPACE);
        Element revnumber = new Element("revnumber", NAMESPACE);
        revnumber.addContent("" + r.revnumber);
        rev.addContent((Content)revnumber);
        Element date = new Element("date", NAMESPACE);
        date.addContent(r.date);
        rev.addContent((Content)date);
        Element authorinitials = new Element("authorinitials", NAMESPACE);
        authorinitials.addContent(r.authorinitials);
        rev.addContent((Content)authorinitials);
        Element revremark = new Element("revremark", NAMESPACE);
        revremark.addContent(r.revremark);
        rev.addContent((Content)revremark);
        return rev;
    }
}

