/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.exceptionhandler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import javax.annotation.Nonnull;
import jmri.util.exceptionhandler.Bundle;
import jmri.util.swing.ExceptionContext;
import jmri.util.swing.ExceptionDisplayFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(UncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if ("java.lang.ThreadDeath".equals(e.getClass().getName())) {
            log.info("Thread has stopped: {}", (Object)t.getName());
            return;
        }
        log.error("Uncaught Exception caught by jmri.util.exceptionhandler.UncaughtExceptionHandler", e);
        if (e instanceof Error) {
            if (!GraphicsEnvironment.isHeadless()) {
                ExceptionDisplayFrame.displayExceptionDisplayFrame(null, new ErrorContext(e));
            }
            log.error("System Exiting");
            this.systemExit();
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Errors should terminate the application")
    protected void systemExit() {
        System.exit(126);
    }

    private static class ErrorContext
    extends ExceptionContext {
        public ErrorContext(@Nonnull Throwable ex) {
            super(ex, "", "");
            this.prefaceString = Bundle.getMessage("UnrecoverableErrorMessage");
        }

        @Override
        public String getTitle() {
            return Bundle.getMessage("UnrecoverableErrorTitle");
        }
    }
}

