/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.gui;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.Bean;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.ThreadingUtil;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiLafPreferencesManager
extends Bean
implements PreferencesManager,
InstanceManagerAutoDefault {
    public static final String FONT_NAME = "fontName";
    public static final String FONT_SIZE = "fontSize";
    public static final String LOCALE = "locale";
    public static final String LOOK_AND_FEEL = "lookAndFeel";
    public static final String NONSTANDARD_MOUSE_EVENT = "nonstandardMouseEvent";
    public static final String GRAPHIC_TABLE_STATE = "graphicTableState";
    public static final String OBLOCK_EDIT_TABBED = "oblockEditTabbed";
    public static final String VERTICAL_TOOLBAR = "verticalToolBar";
    public static final String SHOW_TOOL_TIP_TIME = "showToolTipDismissDelay";
    public static final String EDITOR_USE_OLD_LOC_SIZE = "editorUseOldLocSize";
    public static final String JFILECHOOSER_FORMAT = "jfilechooserformat";
    public static final String MAX_COMBO_ROWS = "maxComboRows";
    public static final int MIN_FONT_SIZE = 9;
    public static final int MAX_FONT_SIZE = 36;
    public static final String PROP_DIRTY = "dirty";
    public static final String PROP_RESTARTREQUIRED = "restartRequired";
    public static final String DEFAULT_FONT = "List.font";
    private Locale locale = Locale.getDefault();
    private Font currentFont = null;
    private Font defaultFont = null;
    private int fontSize = 0;
    private int defaultFontSize = 11;
    private boolean nonStandardMouseEvent = false;
    private boolean graphicTableState = false;
    private boolean oblockEditTabbed = false;
    private boolean editorUseOldLocSize = false;
    private int jFileChooserFormat = 0;
    private String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
    private int toolTipDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
    private int maxComboRows = 0;
    private boolean dirty = false;
    private boolean restartRequired = false;
    private boolean initialized = false;
    private final List<InitializationException> exceptions = new ArrayList<InitializationException>();
    private static final Logger log = LoggerFactory.getLogger(GuiLafPreferencesManager.class);

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.initialized) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            this.setLocale(Locale.forLanguageTag(preferences.get(LOCALE, this.getLocale().toLanguageTag())));
            String lookAndFeelClassname = preferences.get(LOOK_AND_FEEL, this.getLookAndFeel());
            this.setLookAndFeel(lookAndFeelClassname);
            this.setDefaultFontSize();
            this.setFontSize(preferences.getInt(FONT_SIZE, this.getDefaultFontSize()));
            if (this.getFontSize() == 0) {
                this.setFontSize(this.getDefaultFontSize());
            }
            this.setFontByName(preferences.get(FONT_NAME, this.getDefaultFont().getFontName()));
            if (this.getFont() == null) {
                this.setFont(this.getDefaultFont());
            }
            this.setNonStandardMouseEvent(preferences.getBoolean(NONSTANDARD_MOUSE_EVENT, this.isNonStandardMouseEvent()));
            this.setGraphicTableState(preferences.getBoolean(GRAPHIC_TABLE_STATE, this.isGraphicTableState()));
            this.setOblockEditTabbed(preferences.getBoolean(OBLOCK_EDIT_TABBED, this.isOblockEditTabbed()));
            this.setEditorUseOldLocSize(preferences.getBoolean(EDITOR_USE_OLD_LOC_SIZE, this.isEditorUseOldLocSize()));
            this.setJFileChooserFormat(preferences.getInt(JFILECHOOSER_FORMAT, this.getJFileChooserFormat()));
            this.setMaxComboRows(preferences.getInt(MAX_COMBO_ROWS, this.getMaxComboRows()));
            this.setToolTipDismissDelay(preferences.getInt(SHOW_TOOL_TIP_TIME, this.getToolTipDismissDelay()));
            log.debug("About to setDefault Locale");
            Locale.setDefault(this.getLocale());
            JComponent.setDefaultLocale(this.getLocale());
            this.applyLookAndFeel();
            this.applyFontSize();
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized(Profile profile) {
        return this.initialized && this.exceptions.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<Class<? extends PreferencesManager>> getRequires() {
        return new HashSet<Class<? extends PreferencesManager>>();
    }

    @Override
    @Nonnull
    public Iterable<Class<?>> getProvides() {
        HashSet provides = new HashSet();
        provides.add(this.getClass());
        return provides;
    }

    @Override
    public void savePreferences(Profile profile) {
        int temp;
        String prefFontName;
        String currentFontName;
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        preferences.put(LOCALE, this.getLocale().toLanguageTag());
        preferences.put(LOOK_AND_FEEL, this.getLookAndFeel());
        if (this.currentFont == null) {
            this.currentFont = this.getDefaultFont();
        }
        if (!((currentFontName = this.currentFont.getFontName()) == null || (prefFontName = preferences.get(FONT_NAME, currentFontName)) != null && prefFontName.equals(currentFontName))) {
            preferences.put(FONT_NAME, currentFontName);
        }
        if ((temp = this.getFontSize()) == this.getDefaultFontSize()) {
            temp = 0;
        }
        if (temp != preferences.getInt(FONT_SIZE, -1)) {
            preferences.putInt(FONT_SIZE, temp);
        }
        preferences.putBoolean(NONSTANDARD_MOUSE_EVENT, this.isNonStandardMouseEvent());
        preferences.putBoolean(GRAPHIC_TABLE_STATE, this.isGraphicTableState());
        preferences.putBoolean(OBLOCK_EDIT_TABBED, this.isOblockEditTabbed());
        preferences.putBoolean(EDITOR_USE_OLD_LOC_SIZE, this.isEditorUseOldLocSize());
        preferences.putInt(JFILECHOOSER_FORMAT, this.jFileChooserFormat);
        preferences.putInt(MAX_COMBO_ROWS, this.getMaxComboRows());
        preferences.putInt(SHOW_TOOL_TIP_TIME, this.getToolTipDismissDelay());
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences.", (Throwable)ex);
        }
        this.setDirty(false);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Locale oldLocale = this.locale;
        this.locale = locale;
        this.firePropertyChange(LOCALE, oldLocale, locale);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font newFont) {
        Font oldFont = this.currentFont;
        this.currentFont = newFont;
        this.firePropertyChange(FONT_NAME, oldFont, this.currentFont);
    }

    public void setFontByName(String newFontName) {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            oldFont = this.getDefaultFont();
        }
        this.setFont(new Font(newFontName, oldFont.getStyle(), this.fontSize));
    }

    public Font getDefaultFont() {
        if (this.defaultFont == null) {
            this.setDefaultFont();
        }
        return this.defaultFont;
    }

    public void setDefaultFont() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource) || !key.toString().equals(DEFAULT_FONT)) continue;
            Font f = UIManager.getFont(key);
            log.debug("Key:{} Font: {}", key, (Object)f.getName());
            this.defaultFont = f;
            return;
        }
        this.defaultFont = UIManager.getFont(DEFAULT_FONT);
        if (this.defaultFont == null) {
            this.defaultFont = UIManager.getFont("TextArea.font");
        }
    }

    public int getFontSize() {
        if (this.fontSize == 0) {
            return this.defaultFontSize;
        }
        return this.fontSize;
    }

    public void setFontSize(int newFontSize) {
        int oldFontSize = this.fontSize;
        this.fontSize = newFontSize != 0 && newFontSize < 9 ? 9 : (newFontSize > 36 ? 36 : newFontSize);
        this.firePropertyChange(FONT_SIZE, oldFontSize, this.fontSize);
    }

    public int getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public void setDefaultFontSize() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource) || !key.toString().equals(DEFAULT_FONT)) continue;
            Font f = UIManager.getFont(key);
            log.debug("Key:{} Font: {} size: {}", new Object[]{key, f.getName(), f.getSize()});
            this.defaultFontSize = f.getSize();
            return;
        }
        this.defaultFontSize = 11;
    }

    private void logAllFonts() {
        if (log.isTraceEnabled()) {
            log.trace("******** LAF={}", (Object)UIManager.getLookAndFeel().getClass().getName());
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (value == null || !(value instanceof FontUIResource) && !(value instanceof Font) && !key.toString().endsWith(".font")) continue;
                Font f = UIManager.getFont(key);
                log.trace("Class={}; Key: {} Font: {} size: {}", new Object[]{value.getClass().getName(), key, f.getName(), f.getSize()});
            }
        }
    }

    public void setToolTipDismissDelay(int time) {
        int old = this.toolTipDismissDelay;
        this.toolTipDismissDelay = time;
        ToolTipManager.sharedInstance().setDismissDelay(time);
        this.firePropertyChange(SHOW_TOOL_TIP_TIME, old, time);
    }

    public int getToolTipDismissDelay() {
        return this.toolTipDismissDelay;
    }

    public boolean isNonStandardMouseEvent() {
        return this.nonStandardMouseEvent;
    }

    public void setNonStandardMouseEvent(boolean nonStandardMouseEvent) {
        boolean oldNonStandardMouseEvent = this.nonStandardMouseEvent;
        this.nonStandardMouseEvent = nonStandardMouseEvent;
        this.firePropertyChange(NONSTANDARD_MOUSE_EVENT, oldNonStandardMouseEvent, nonStandardMouseEvent);
    }

    public boolean isGraphicTableState() {
        return this.graphicTableState;
    }

    public void setGraphicTableState(boolean graphicTableState) {
        boolean oldGraphicTableState = this.graphicTableState;
        this.graphicTableState = graphicTableState;
        this.firePropertyChange(GRAPHIC_TABLE_STATE, oldGraphicTableState, graphicTableState);
    }

    public boolean isOblockEditTabbed() {
        return this.oblockEditTabbed;
    }

    public void setOblockEditTabbed(boolean tabbed) {
        boolean oldOblockTabbed = this.oblockEditTabbed;
        this.oblockEditTabbed = tabbed;
        this.firePropertyChange(OBLOCK_EDIT_TABBED, oldOblockTabbed, tabbed);
    }

    public int getMaxComboRows() {
        return this.maxComboRows;
    }

    public void setMaxComboRows(int maxRows) {
        this.maxComboRows = maxRows;
    }

    public boolean isEditorUseOldLocSize() {
        return this.editorUseOldLocSize;
    }

    public void setEditorUseOldLocSize(boolean editorUseOldLocSize) {
        boolean oldEditorUseOldLocSize = this.editorUseOldLocSize;
        this.editorUseOldLocSize = editorUseOldLocSize;
        this.firePropertyChange(EDITOR_USE_OLD_LOC_SIZE, oldEditorUseOldLocSize, editorUseOldLocSize);
    }

    public int getJFileChooserFormat() {
        return this.jFileChooserFormat;
    }

    public void setJFileChooserFormat(int jFileChooserFormat) {
        int oldjFileChooserFormat = this.jFileChooserFormat;
        this.jFileChooserFormat = jFileChooserFormat;
        this.firePropertyChange(JFILECHOOSER_FORMAT, oldjFileChooserFormat, jFileChooserFormat);
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        String oldLookAndFeel = this.lookAndFeel;
        this.lookAndFeel = lookAndFeel;
        this.firePropertyChange(LOOK_AND_FEEL, oldLookAndFeel, lookAndFeel);
    }

    public void applyLookAndFeel() {
        String lafClassName = this.lookAndFeel;
        for (UIManager.LookAndFeelInfo LAF : UIManager.getInstalledLookAndFeels()) {
            if (!LAF.getClassName().equals(this.lookAndFeel) && !LAF.getName().equals(this.lookAndFeel)) continue;
            lafClassName = LAF.getClassName();
            break;
        }
        log.debug("Look and feel selection \"{}\" ({})", (Object)this.lookAndFeel, (Object)lafClassName);
        if (lafClassName != null) {
            if (!lafClassName.equals(UIManager.getLookAndFeel().getClass().getName())) {
                log.debug("Apply look and feel \"{}\" ({})", (Object)this.lookAndFeel, (Object)lafClassName);
                String localLafClassName = lafClassName;
                ThreadingUtil.runOnGUI(() -> {
                    try {
                        if (localLafClassName.startsWith("com.github.weisj.darklaf")) {
                            LafManager.install((Theme)new HighContrastDarkTheme());
                        } else {
                            UIManager.setLookAndFeel(localLafClassName);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        log.error("Could not find look and feel \"{}\".", (Object)this.lookAndFeel);
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        log.error("Could not load look and feel \"{}\".", (Object)this.lookAndFeel);
                    }
                    catch (UnsupportedLookAndFeelException ex) {
                        log.error("Look and feel \"{}\" is not supported on this platform.", (Object)this.lookAndFeel);
                    }
                });
            } else {
                log.debug("Not updating look and feel {} matching existing look and feel", (Object)lafClassName);
            }
        }
    }

    private void applyFontSize() {
        if (log.isTraceEnabled()) {
            this.logAllFonts();
        }
        if (this.getFontSize() != this.getDefaultFontSize()) {
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (value == null || !(value instanceof FontUIResource) && !(value instanceof Font) && !key.toString().endsWith(".font")) continue;
                UIManager.put(key, UIManager.getFont(key).deriveFont(((Font)value).getStyle(), this.getCalcFontSize(((Font)value).getSize())));
            }
            if (log.isTraceEnabled()) {
                this.logAllFonts();
            }
        }
    }

    public static void setLocaleMinimally(Profile profile) {
        String name = ProfileUtils.getPreferences(profile, GuiLafPreferencesManager.class, true).get(LOCALE, "en");
        log.debug("setLocaleMinimally found language {}, setting", (Object)name);
        Locale.setDefault(new Locale(name));
        JComponent.setDefaultLocale(new Locale(name));
    }

    private int getCalcFontSize(int oldSize) {
        return oldSize + (this.getFontSize() - this.getDefaultFontSize());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        if (this.initialized) {
            boolean oldDirty = this.dirty;
            this.dirty = dirty;
            super.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
        }
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    private void setRestartRequired() {
        if (this.initialized && !this.restartRequired) {
            this.restartRequired = true;
            super.firePropertyChange(PROP_RESTARTREQUIRED, false, this.restartRequired);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.setDirty(true);
            this.setRestartRequired();
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.setDirty(true);
            this.setRestartRequired();
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || oldValue != newValue) {
            this.setDirty(true);
            this.setRestartRequired();
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public boolean isInitializedWithExceptions(Profile profile) {
        return this.initialized && !this.exceptions.isEmpty();
    }

    @Override
    @Nonnull
    public List<Exception> getInitializationExceptions(Profile profile) {
        return new ArrayList<Exception>(this.exceptions);
    }
}

