/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.iharder.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import jmri.util.iharder.dnd.TransferableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDList<E>
extends JList<E>
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DragSource dragSource = null;
    private int sourceIndex = -1;
    private static final Logger log = LoggerFactory.getLogger(DnDList.class);

    public DnDList() {
        super(new DefaultListModel());
        this.initComponents();
    }

    public DnDList(DefaultListModel<E> model) {
        super(model);
        this.initComponents();
    }

    public DnDList(E[] data) {
        this();
        ((DefaultListModel)this.getModel()).copyInto(data);
    }

    public DnDList(Vector<E> data) {
        this();
        ((DefaultListModel)this.getModel()).copyInto(data.toArray());
    }

    private void initComponents() {
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        final Object selected = this.getSelectedValue();
        if (selected != null) {
            this.sourceIndex = this.getSelectedIndex();
            TransferableObject transfer = new TransferableObject(new TransferableObject.Fetcher(){

                public E getObject() {
                    ((DefaultListModel)DnDList.this.getModel()).remove(DnDList.this.sourceIndex);
                    return selected;
                }
            });
            this.dragSource.startDrag(event, DragSource.DefaultLinkDrop, transfer, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        evt.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        evt.acceptDrag(2);
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        Transferable transferable = evt.getTransferable();
        if (transferable.isDataFlavorSupported(TransferableObject.DATA_FLAVOR)) {
            evt.acceptDrop(2);
            Object obj = null;
            try {
                obj = transferable.getTransferData(TransferableObject.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.error("Unable to transfer object", (Throwable)e);
            }
            if (obj != null) {
                int dropIndex = this.locationToIndex(evt.getLocation());
                DefaultListModel model = (DefaultListModel)this.getModel();
                if (dropIndex < 0) {
                    model.addElement(obj);
                } else if (this.sourceIndex >= 0 && dropIndex > this.sourceIndex) {
                    model.add(dropIndex - 1, obj);
                } else {
                    model.add(dropIndex, obj);
                }
            } else {
                evt.rejectDrop();
            }
        } else {
            evt.rejectDrop();
        }
    }
}

