/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.jdom;

import java.util.Arrays;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class LocaleSelector {
    static String[] suffixes = new String[]{Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry(), Locale.getDefault().getLanguage(), ""};
    static boolean testLocale = Locale.getDefault().getLanguage().equals("tlh");

    public static String getAttribute(Element el, String name) {
        for (String suffix : suffixes) {
            String retval = LocaleSelector.checkElement(el, name, suffix);
            if (retval == null) continue;
            if (testLocale) {
                return retval.toUpperCase();
            }
            return retval;
        }
        for (Object obj : el.getChildren(name)) {
            Element e = (Element)obj;
            Attribute a = e.getAttribute("lang", Namespace.XML_NAMESPACE);
            if (a != null) continue;
            if (testLocale) {
                return e.getText().toUpperCase();
            }
            return e.getText();
        }
        Attribute a = el.getAttribute(name);
        if (a == null) {
            return null;
        }
        if (testLocale) {
            return a.getValue().toUpperCase();
        }
        return a.getValue();
    }

    static String checkElement(Element el, String name, String suffix) {
        for (Object obj : el.getChildren(name)) {
            Element e = (Element)obj;
            Attribute a = e.getAttribute("lang", Namespace.XML_NAMESPACE);
            if (a == null || !a.getValue().equals(suffix)) continue;
            return e.getText();
        }
        return null;
    }

    protected static void setSuffixes(String[] newSuffixes) {
        suffixes = Arrays.copyOf(newSuffixes, newSuffixes.length);
    }
}

