/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.beans.Bean;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.spi.PreferencesManager;
import jmri.util.prefs.InitializationException;

public abstract class AbstractPreferencesManager
extends Bean
implements PreferencesManager {
    private final HashMap<Profile, Boolean> initialized = new HashMap();
    private final HashMap<Profile, Boolean> initializing = new HashMap();
    private final HashMap<Profile, List<Exception>> exceptions = new HashMap();

    @Override
    public boolean isInitialized(Profile profile) {
        return this.initialized.getOrDefault(profile, false) != false && ((List)this.exceptions.getOrDefault(profile, new ArrayList())).isEmpty();
    }

    @Override
    public boolean isInitializedWithExceptions(Profile profile) {
        return this.initialized.getOrDefault(profile, false) != false && !((List)this.exceptions.getOrDefault(profile, new ArrayList())).isEmpty();
    }

    @Override
    @Nonnull
    public List<Exception> getInitializationExceptions(Profile profile) {
        return new ArrayList<Exception>(this.exceptions.getOrDefault(profile, new ArrayList()));
    }

    protected boolean isInitializing(Profile profile) {
        return this.initialized.getOrDefault(profile, false) == false && this.initializing.getOrDefault(profile, false) != false;
    }

    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        HashSet<Class<? extends PreferencesManager>> requires = new HashSet<Class<? extends PreferencesManager>>();
        requires.add(ConnectionConfigManager.class);
        return requires;
    }

    @Nonnull
    public Set<Class<?>> getProvides() {
        HashSet provides = new HashSet();
        provides.add(this.getClass());
        return provides;
    }

    protected void setInitialized(Profile profile, boolean initialized) {
        this.initialized.put(profile, initialized);
        if (initialized) {
            this.setInitializing(profile, false);
        }
    }

    protected void setInitializing(Profile profile, boolean initializing) {
        this.initializing.put(profile, initializing);
    }

    protected void addInitializationException(Profile profile, @Nonnull Exception exception) {
        if (this.exceptions.get(profile) == null) {
            this.exceptions.put(profile, new ArrayList());
        }
        this.exceptions.get(profile).add(exception);
    }

    protected void requiresNoInitializedWithExceptions(Profile profile, @Nonnull Set<Class<? extends PreferencesManager>> classes, @Nonnull String message) throws InitializationException {
        classes.stream().filter(clazz -> !this.getRequires().contains(clazz)).forEach(clazz -> {
            throw new IllegalArgumentException("Class " + clazz.getClass().getName() + " not marked as required by " + this.getClass().getName());
        });
        for (Class<? extends PreferencesManager> clazz2 : classes) {
            for (PreferencesManager preferencesManager : InstanceManager.getList(clazz2)) {
                if (!preferencesManager.isInitializedWithExceptions(profile)) continue;
                InitializationException exception = new InitializationException("Refusing to initialize", message);
                this.addInitializationException(profile, exception);
                this.setInitialized(profile, true);
                throw exception;
            }
        }
    }

    protected void requiresNoInitializedWithExceptions(Profile profile, @Nonnull String message) throws InitializationException {
        this.requiresNoInitializedWithExceptions(profile, (Set<Class<? extends PreferencesManager>>)this.getRequires(), message);
    }

    @Nonnull
    protected Set<Class<? extends PreferencesManager>> requireAllOther() {
        return InstanceManager.getList(PreferencesManager.class).stream().filter(pm -> !pm.equals(this)).map(pm -> pm.getClass()).collect(Collectors.toSet());
    }
}

