/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import jmri.profile.AuxiliaryConfiguration;
import jmri.util.FileUtil;
import jmri.util.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class JmriConfiguration
implements AuxiliaryConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JmriConfiguration.class);

    JmriConfiguration() {
    }

    protected abstract File getConfigurationFile(boolean var1);

    protected abstract boolean isSharedBackedUp();

    protected abstract void setSharedBackedUp(boolean var1);

    protected abstract boolean isPrivateBackedUp();

    protected abstract void setPrivateBackedUp(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            Element element;
            File file = this.getConfigurationFile(shared);
            if (file == null || !file.canRead()) return null;
            FileInputStream is = new FileInputStream(file);
            try {
                InputSource input = new InputSource(is);
                input.setSystemId(file.toURI().toURL().toString());
                Element root = XMLUtil.parse(input, false, true, null, null).getDocumentElement();
                element = XMLUtil.findElement(root, elementName, namespace);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException | SAXException ex) {
                    log.warn("Cannot parse {}", (Object)file, (Object)ex);
                }
                return null;
            }
            ((InputStream)is).close();
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            Element root;
            Element oldFragment;
            String elementName = fragment.getLocalName();
            String namespace = fragment.getNamespaceURI();
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            File file = this.getConfigurationFile(shared);
            Document doc = null;
            if (file != null && file.canRead()) {
                try (FileInputStream is = new FileInputStream(file);){
                    InputSource input = new InputSource(is);
                    input.setSystemId(file.toURI().toURL().toString());
                    doc = XMLUtil.parse(input, false, true, null, null);
                }
                catch (IOException | SAXException ex) {
                    log.warn("Cannot parse {}", (Object)file, (Object)ex);
                }
            }
            if (doc == null) {
                doc = XMLUtil.createDocument("auxiliary-configuration", "http://www.netbeans.org/ns/auxiliary-configuration/1", null, null);
            }
            if ((oldFragment = XMLUtil.findElement(root = doc.getDocumentElement(), elementName, namespace)) != null) {
                root.removeChild(oldFragment);
            }
            Node ref = null;
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                int comparison = node.getNodeName().compareTo(elementName);
                if (comparison == 0) {
                    comparison = node.getNamespaceURI().compareTo(namespace);
                }
                if (comparison <= 0) continue;
                ref = node;
                break;
            }
            root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
            try {
                this.backup(shared);
                try (FileOutputStream os = new FileOutputStream(file);){
                    XMLUtil.write(doc, os, StandardCharsets.UTF_8.name());
                }
            }
            catch (IOException ex) {
                log.error("Cannot write {}", (Object)file, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
        JmriConfiguration jmriConfiguration = this;
        synchronized (jmriConfiguration) {
            File file = this.getConfigurationFile(shared);
            if (file.canWrite()) {
                try {
                    Document doc;
                    try (FileInputStream is = new FileInputStream(file);){
                        InputSource input = new InputSource(is);
                        input.setSystemId(file.toURI().toURL().toString());
                        doc = XMLUtil.parse(input, false, true, null, null);
                    }
                    Element root = doc.getDocumentElement();
                    Element toRemove = XMLUtil.findElement(root, elementName, namespace);
                    if (toRemove != null) {
                        root.removeChild(toRemove);
                        this.backup(shared);
                        if (root.getElementsByTagName("*").getLength() > 0) {
                            try (FileOutputStream os = new FileOutputStream(file);){
                                XMLUtil.write(doc, os, StandardCharsets.UTF_8.name());
                            }
                        } else if (!file.delete()) {
                            log.debug("Unable to delete {}", (Object)file);
                        }
                        return true;
                    }
                }
                catch (IOException | DOMException | SAXException ex) {
                    log.error("Cannot remove {} from {}", new Object[]{elementName, file, ex});
                }
            }
            return false;
        }
    }

    private void backup(boolean shared) {
        File file = this.getConfigurationFile(shared);
        if (!(!shared ? this.isPrivateBackedUp() : this.isSharedBackedUp()) && file.exists()) {
            log.debug("Backing up {}", (Object)file);
            try {
                FileUtil.backup(file);
                if (shared) {
                    this.setSharedBackedUp(true);
                } else {
                    this.setPrivateBackedUp(true);
                }
            }
            catch (IOException ex) {
                log.error("Error backing up {}", (Object)file, (Object)ex);
            }
        }
    }
}

