/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmri.profile.AuxiliaryConfiguration;
import jmri.profile.Profile;
import jmri.util.prefs.AbstractConfigurationProvider;
import jmri.util.prefs.JmriConfiguration;

public final class JmriConfigurationProvider
extends AbstractConfigurationProvider {
    private final JmriConfiguration configuration = new Configuration();
    public static final String NAMESPACE = "http://www.netbeans.org/ns/auxiliary-configuration/1";
    private static final HashMap<Profile, JmriConfigurationProvider> PROVIDERS;

    static synchronized JmriConfigurationProvider findProvider(Profile project) {
        if (PROVIDERS.get(project) == null) {
            PROVIDERS.put(project, new JmriConfigurationProvider(project));
        }
        return PROVIDERS.get(project);
    }

    public static AuxiliaryConfiguration getConfiguration(Profile project) {
        return JmriConfigurationProvider.findProvider(project).getConfiguration();
    }

    @Override
    protected AuxiliaryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected File getConfigurationFile(boolean shared) {
        if (this.project == null) {
            return new File(this.getConfigurationDirectory(shared), "profile.xml");
        }
        return new File(this.getConfigurationDirectory(shared), "profile.xml");
    }

    JmriConfigurationProvider(Profile project) {
        super(project);
    }

    static {
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        PROVIDERS = new HashMap();
    }

    private class Configuration
    extends JmriConfiguration {
        private Configuration() {
        }

        @Override
        protected File getConfigurationFile(boolean shared) {
            return JmriConfigurationProvider.this.getConfigurationFile(shared);
        }

        @Override
        protected boolean isSharedBackedUp() {
            return JmriConfigurationProvider.this.isSharedBackedUp();
        }

        @Override
        protected void setSharedBackedUp(boolean backedUp) {
            JmriConfigurationProvider.this.setSharedBackedUp(backedUp);
        }

        @Override
        protected boolean isPrivateBackedUp() {
            return JmriConfigurationProvider.this.isPrivateBackedUp();
        }

        @Override
        protected void setPrivateBackedUp(boolean backedUp) {
            JmriConfigurationProvider.this.setPrivateBackedUp(backedUp);
        }
    }
}

