/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Version;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.util.FileUtil;
import jmri.util.OrderedProperties;
import jmri.util.node.NodeIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmriPreferencesProvider {
    private final JmriPreferences root;
    private final File path;
    private final boolean firstUse;
    private final boolean shared;
    private boolean backedUp = false;
    private static final HashMap<File, JmriPreferencesProvider> SHARED_PROVIDERS = new HashMap();
    private static final HashMap<File, JmriPreferencesProvider> PRIVATE_PROVIDERS = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(JmriPreferencesProvider.class);

    @Nonnull
    static synchronized JmriPreferencesProvider findProvider(@CheckForNull File path, boolean shared) {
        if (shared) {
            return SHARED_PROVIDERS.computeIfAbsent(path, v -> new JmriPreferencesProvider(path, shared));
        }
        return PRIVATE_PROVIDERS.computeIfAbsent(path, v -> new JmriPreferencesProvider(path, shared));
    }

    @Nonnull
    public static Preferences getPreferences(@CheckForNull Profile project, @CheckForNull Class<?> clazz, boolean shared) {
        return JmriPreferencesProvider.getPreferences(project, clazz != null ? clazz.getPackage() : null, shared);
    }

    @Nonnull
    public static Preferences getPreferences(@CheckForNull Profile project, @CheckForNull Package pkg, boolean shared) {
        if (project != null) {
            return JmriPreferencesProvider.findProvider(project.getPath(), shared).getPreferences(pkg);
        }
        return JmriPreferencesProvider.findProvider(null, shared).getPreferences(pkg);
    }

    @Nonnull
    public static Preferences getPreferences(@CheckForNull Profile project, @CheckForNull String pkg, boolean shared) {
        if (project != null) {
            return JmriPreferencesProvider.findProvider(project.getPath(), shared).getPreferences(pkg);
        }
        return JmriPreferencesProvider.findProvider(null, shared).getPreferences(pkg);
    }

    public static Preferences getPreferences(@CheckForNull File path, @CheckForNull Class<?> clazz, boolean shared) {
        return JmriPreferencesProvider.findProvider(path, shared).getPreferences(clazz);
    }

    Preferences getPreferences(@CheckForNull Package pkg) {
        if (pkg == null) {
            return this.root;
        }
        return this.root.node(JmriPreferencesProvider.findCNBForPackage(pkg));
    }

    Preferences getPreferences(@CheckForNull Class<?> clazz) {
        return this.getPreferences(clazz != null ? clazz.getPackage() : null);
    }

    Preferences getPreferences(@CheckForNull String pkg) {
        if (pkg == null) {
            return this.root;
        }
        return this.root.node(pkg);
    }

    JmriPreferencesProvider(@CheckForNull File path, boolean shared) {
        this.path = path;
        this.shared = shared;
        this.firstUse = !this.getPreferencesFile().exists();
        this.root = new JmriPreferences(null, "");
        if (!this.firstUse) {
            try {
                this.root.sync();
            }
            catch (BackingStoreException ex) {
                log.error("Unable to read preferences", (Throwable)ex);
            }
        }
    }

    public boolean isFirstUse() {
        return this.firstUse;
    }

    public static String findCNBForClass(@Nonnull Class<?> cls) {
        return JmriPreferencesProvider.findCNBForPackage(cls.getPackage());
    }

    public static String findCNBForPackage(@Nonnull Package pkg) {
        return pkg.getName().replace('.', '-');
    }

    @Nonnull
    File getPreferencesFile() {
        if (this.path == null) {
            return new File(this.getPreferencesDirectory(), "preferences.properties");
        }
        return new File(this.getPreferencesDirectory(), "profile.properties");
    }

    @Nonnull
    private File getPreferencesDirectory() {
        File dir;
        if (this.path == null) {
            dir = new File(FileUtil.getPreferencesPath(), "preferences");
        } else {
            dir = new File(this.path, "profile");
            if (!this.shared) {
                if (Profile.isProfile(this.path)) {
                    try {
                        Profile profile = new Profile(this.path);
                        File nodeDir = new File(dir, NodeIdentity.storageIdentity(profile));
                        if (!nodeDir.exists() && !ProfileUtils.copyPrivateContentToCurrentIdentity(profile)) {
                            log.debug("Starting profile with new private preferences.");
                        }
                    }
                    catch (IOException ex) {
                        log.debug("Copying existing private configuration failed.");
                    }
                }
                dir = new File(dir, NodeIdentity.storageIdentity());
            }
        }
        FileUtil.createDirectory(dir);
        return dir;
    }

    protected boolean isBackedUp() {
        return this.backedUp;
    }

    protected void setBackedUp(boolean backedUp) {
        this.backedUp = backedUp;
    }

    private class JmriPreferences
    extends AbstractPreferences {
        private final Map<String, String> theRoot;
        private final Map<String, JmriPreferences> children;
        private boolean isRemoved;
        private final Logger log;

        public JmriPreferences(AbstractPreferences parent, String name) {
            super(parent, name);
            this.isRemoved = false;
            this.log = LoggerFactory.getLogger(JmriPreferences.class);
            this.log.trace("Instantiating node \"{}\"", (Object)name);
            this.theRoot = new TreeMap<String, String>();
            this.children = new TreeMap<String, JmriPreferences>();
            try {
                super.sync();
            }
            catch (BackingStoreException e) {
                this.log.error("Unable to sync on creation of node {}", (Object)name, (Object)e);
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.theRoot.put(key, value);
            try {
                this.flush();
            }
            catch (BackingStoreException e) {
                this.log.error("Unable to flush after putting {}", (Object)key, (Object)e);
            }
        }

        @Override
        protected String getSpi(String key) {
            return this.theRoot.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.theRoot.remove(key);
            try {
                this.flush();
            }
            catch (BackingStoreException e) {
                this.log.error("Unable to flush after removing {}", (Object)key, (Object)e);
            }
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            this.isRemoved = true;
            this.flush();
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            return this.theRoot.keySet().toArray(new String[this.theRoot.keySet().size()]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            return this.children.keySet().toArray(new String[this.children.keySet().size()]);
        }

        @Override
        protected JmriPreferences childSpi(String name) {
            JmriPreferences child = this.children.get(name);
            if (child == null || child.isRemoved()) {
                child = new JmriPreferences(this, name);
                this.children.put(name, child);
            }
            return child;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void syncSpi() throws BackingStoreException {
            if (this.isRemoved()) {
                return;
            }
            File file = JmriPreferencesProvider.this.getPreferencesFile();
            if (!file.exists()) {
                return;
            }
            File file2 = file;
            synchronized (file2) {
                OrderedProperties p = new OrderedProperties();
                try {
                    try (FileInputStream fis = new FileInputStream(file);){
                        p.load(fis);
                    }
                    StringBuilder sb = new StringBuilder();
                    this.getPath(sb);
                    String pp = sb.toString();
                    Enumeration<?> pnen = p.propertyNames();
                    while (pnen.hasMoreElements()) {
                        String subKey;
                        String propKey = (String)pnen.nextElement();
                        if (!propKey.startsWith(pp) || (subKey = propKey.substring(pp.length())).indexOf(46) != -1) continue;
                        this.theRoot.put(subKey, p.getProperty(propKey));
                    }
                }
                catch (IOException e) {
                    throw new BackingStoreException(e);
                }
            }
        }

        private void getPath(StringBuilder sb) {
            JmriPreferences parent = (JmriPreferences)this.parent();
            if (parent == null) {
                return;
            }
            parent.getPath(sb);
            sb.append(this.name()).append('.');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void flushSpi() throws BackingStoreException {
            File file;
            File file2 = file = JmriPreferencesProvider.this.getPreferencesFile();
            synchronized (file2) {
                OrderedProperties p = new OrderedProperties();
                try {
                    StringBuilder sb = new StringBuilder();
                    this.getPath(sb);
                    String pp = sb.toString();
                    if (file.exists()) {
                        try (FileInputStream fis = new FileInputStream(file);){
                            p.load(fis);
                        }
                        ArrayList<String> toRemove = new ArrayList<String>();
                        Enumeration<?> pnen = p.propertyNames();
                        while (pnen.hasMoreElements()) {
                            String subKey;
                            String propKey = (String)pnen.nextElement();
                            if (!propKey.startsWith(pp) || (subKey = propKey.substring(pp.length())).indexOf(46) != -1) continue;
                            toRemove.add(propKey);
                        }
                        toRemove.stream().forEach(p::remove);
                    }
                    if (!this.isRemoved) {
                        this.theRoot.keySet().stream().forEach(s -> p.setProperty(pp + s, this.theRoot.get(s)));
                    }
                    if (!JmriPreferencesProvider.this.isBackedUp() && file.exists()) {
                        this.log.debug("Backing up {}", (Object)file);
                        FileUtil.backup(file);
                        JmriPreferencesProvider.this.setBackedUp(true);
                    }
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        p.store(fos, "JMRI Preferences version " + Version.name());
                    }
                }
                catch (IOException e) {
                    throw new BackingStoreException(e);
                }
            }
        }
    }
}

