/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.startup;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.jmrix.swing.SystemConnectionAction;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.startup.AbstractActionModel;
import jmri.util.startup.Bundle;
import jmri.util.startup.StartupActionModelUtil;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import jmri.util.startup.StartupModelFactory;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionModelFactory
implements StartupModelFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractActionModelFactory.class);

    @Override
    public String getDescription() {
        return Bundle.getMessage(this.getModelClass().getCanonicalName());
    }

    @Override
    public String getActionText() {
        return Bundle.getMessage("EditableStartupAction", this.getDescription());
    }

    public abstract String getEditModelMessage();

    @Override
    public void editModel(StartupModel model, Component parent) {
        if (model instanceof AbstractActionModel && this.getModelClass().isInstance(model)) {
            int result;
            JList<String> actions = new JList<String>(StartupActionModelUtil.getDefault().getNames());
            JComboBox<String> connections = new JComboBox<String>();
            JPanel message = this.getDialogMessage(actions, connections);
            actions.setSelectedValue(model.getName(), true);
            String userName = ConnectionNameFromSystemName.getConnectionName(((AbstractActionModel)model).getSystemPrefix());
            if (userName == null) {
                userName = "";
            }
            if (!userName.isEmpty()) {
                connections.setSelectedItem(userName);
            }
            if ((result = JmriJOptionPane.showConfirmDialog(parent, message, this.getDescription(), 2, -1)) == 0 && actions.getSelectedIndex() >= 0) {
                String name = actions.getSelectedValue();
                Optional<StartupActionsManager> manager = InstanceManager.getOptionalDefault(StartupActionsManager.class);
                if (!name.equals(model.getName())) {
                    model.setName(name);
                    manager.ifPresent(StartupActionsManager::setRestartRequired);
                }
                if (userName.isEmpty() && connections.getSelectedItem() != null || !userName.equals(connections.getSelectedItem())) {
                    ((AbstractActionModel)model).setSystemPrefix(ConnectionNameFromSystemName.getPrefixFromName((String)connections.getSelectedItem()));
                    manager.ifPresent(StartupActionsManager::setRestartRequired);
                }
            }
        }
    }

    @Override
    public void initialize() {
    }

    private JPanel getDialogMessage(JList<String> actions, JComboBox<String> connections) {
        JLabel connectionsLabel = new JLabel(Bundle.getMessage("AbstractActionModelFactory.getDialogMessage.connectionsLabel", 10));
        actions.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                String className;
                connections.removeAllItems();
                connections.setEnabled(false);
                connectionsLabel.setEnabled(false);
                String name = (String)actions.getSelectedValue();
                if (name != null && (className = StartupActionModelUtil.getDefault().getClassName(name)) != null && StartupActionModelUtil.getDefault().isSystemConnectionAction(className)) {
                    try {
                        Action action = (Action)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (action instanceof SystemConnectionAction) {
                            ((SystemConnectionAction)((Object)action)).getSystemConnectionMemoClasses().forEach(clazz -> InstanceManager.getList(SystemConnectionMemo.class).stream().filter(memo -> clazz.isAssignableFrom(memo.getClass())).forEach(memo -> {
                                connections.addItem(memo.getUserName());
                                connections.setEnabled(true);
                                connectionsLabel.setEnabled(true);
                            }));
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        log.error("Unable to create Action", (Throwable)ex);
                    }
                }
            }
        });
        connections.setEnabled(false);
        connectionsLabel.setEnabled(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel(this.getEditModelMessage(), 10));
        panel.add(new JScrollPane(actions));
        panel.add(connectionsLabel);
        panel.add(connections);
        return panel;
    }
}

