/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.startup;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.jdom.JDOMUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import jmri.util.startup.Bundle;
import jmri.util.startup.StartupActionModelUtil;
import jmri.util.startup.StartupModel;
import jmri.util.startup.StartupModelFactory;
import jmri.util.startup.StartupRunnable;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupActionsManager
extends AbstractPreferencesManager {
    private final List<StartupModel> actions = new ArrayList<StartupModel>();
    private final HashMap<Class<? extends StartupModel>, StartupModelFactory> factories = new HashMap();
    private boolean isDirty = false;
    private boolean restartRequired = false;
    public static final String STARTUP = "startup";
    public static final String NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/startup-4-3-5.xsd";
    public static final String NAMESPACE_OLD = "http://jmri.org/xml/schema/auxiliary-configuration/startup-2-9-6.xsd";
    private static final Logger log = LoggerFactory.getLogger(StartupActionsManager.class);

    public StartupActionsManager() {
        for (StartupModelFactory factory : ServiceLoader.load(StartupModelFactory.class)) {
            factory.initialize();
            this.factories.put(factory.getModelClass(), factory);
        }
    }

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            boolean perform = true;
            try {
                this.requiresNoInitializedWithExceptions(profile, Bundle.getMessage("StartupActionsManager.RefusalToInitialize"));
            }
            catch (InitializationException ex) {
                perform = false;
            }
            try {
                Element startup;
                try {
                    startup = JDOMUtil.toJDOMElement(ProfileUtils.getAuxiliaryConfiguration(profile).getConfigurationFragment(STARTUP, NAMESPACE, true));
                }
                catch (NullPointerException ex) {
                    log.debug("Reading element from version 2.9.6 namespace...");
                    startup = JDOMUtil.toJDOMElement(ProfileUtils.getAuxiliaryConfiguration(profile).getConfigurationFragment(STARTUP, NAMESPACE_OLD, true));
                }
                for (Element action2 : startup.getChildren()) {
                    String adapter = action2.getAttributeValue("class");
                    String name = action2.getAttributeValue("name");
                    String override = StartupActionModelUtil.getDefault().getOverride(name);
                    if (override != null) {
                        action2.setAttribute("name", override);
                        log.info("Overriding startup action class {} with {}", (Object)name, (Object)override);
                        this.addInitializationException(profile, new InitializationException(Bundle.getMessage(Locale.ENGLISH, "StartupActionsOverriddenClasses", name, override), Bundle.getMessage("StartupActionsOverriddenClasses", name, override)));
                        name = override;
                    }
                    String type = action2.getAttributeValue("type");
                    log.debug("Read {} {} adapter {}", new Object[]{type, name, adapter});
                    try {
                        log.debug("Creating {} {} adapter {}...", new Object[]{type, name, adapter});
                        ((XmlAdapter)Class.forName(adapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).load(action2, null);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                        log.error("Unable to create {} for {}", new Object[]{adapter, action2, ex});
                        this.addInitializationException(profile, new InitializationException(Bundle.getMessage(Locale.ENGLISH, "StartupActionsCreationError", adapter, name), Bundle.getMessage("StartupActionsCreationError", adapter, name)));
                    }
                    catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | JmriConfigureXmlException ex) {
                        log.error("Unable to load {} into {}", new Object[]{action2, adapter, ex});
                        this.addInitializationException(profile, new InitializationException(Bundle.getMessage(Locale.ENGLISH, "StartupActionsLoadError", adapter, name), Bundle.getMessage("StartupActionsLoadError", adapter, name)));
                    }
                }
            }
            catch (NullPointerException ex) {
                log.debug("No element to read");
            }
            if (perform) {
                this.actions.stream().filter(action -> action.isValid()).forEachOrdered(action -> {
                    try {
                        if (action.isEnabled()) {
                            action.performAction();
                        }
                    }
                    catch (JmriException ex) {
                        this.addInitializationException(profile, ex);
                    }
                });
                ServiceLoader.load(StartupRunnable.class).forEach(Runnable::run);
            }
            this.isDirty = false;
            this.restartRequired = false;
            this.setInitialized(profile, true);
            List<Exception> exceptions = this.getInitializationExceptions(profile);
            if (exceptions.size() == 1) {
                throw new InitializationException(exceptions.get(0));
            }
            if (exceptions.size() > 1) {
                throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, "StartupActionsMultipleErrors", new Object[0]), Bundle.getMessage("StartupActionsMultipleErrors"));
            }
        }
    }

    @Override
    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        return this.requireAllOther();
    }

    @Override
    public synchronized void savePreferences(Profile profile) {
        Element element = new Element(STARTUP, NAMESPACE);
        this.actions.stream().forEach(action -> {
            log.debug("model is {} ({})", (Object)action.getName(), action);
            if (action.getName() != null) {
                Element e = ConfigXmlManager.elementFromObject(action, true);
                if (e != null) {
                    element.addContent((Content)e);
                }
            } else {
                log.error("model \"{}\" does not have a name.", action, (Object)new Exception());
            }
        });
        try {
            ProfileUtils.getAuxiliaryConfiguration(profile).putConfigurationFragment(JDOMUtil.toW3CElement(element), true);
            this.isDirty = false;
        }
        catch (JDOMException ex) {
            log.error("Unable to create create XML", (Throwable)ex);
        }
    }

    public StartupModel[] getActions() {
        return (StartupModel[])this.actions.toArray(StartupModel[]::new);
    }

    public <T extends StartupModel> List<T> getActions(Class<T> type) {
        ArrayList result = new ArrayList();
        this.actions.stream().filter(action -> type.isInstance(action)).forEach(action -> result.add(action));
        return result;
    }

    public StartupModel getActions(int index) {
        return this.actions.get(index);
    }

    public void setActions(int index, StartupModel model) {
        this.setActions(index, model, true);
    }

    private void setActions(int index, StartupModel model, boolean fireChange) {
        if (!this.actions.contains(model)) {
            this.actions.add(index, model);
            this.setRestartRequired();
            if (fireChange) {
                this.fireIndexedPropertyChange(STARTUP, index, null, model);
            }
        }
    }

    public void moveAction(int start, int end) {
        StartupModel model = this.getActions(start);
        this.removeAction(model, false);
        this.setActions(end, model, false);
        this.fireIndexedPropertyChange(STARTUP, end, (Object)start, model);
    }

    public void addAction(StartupModel model) {
        this.setActions(this.actions.size(), model);
    }

    public void removeAction(StartupModel model) {
        this.removeAction(model, true);
    }

    private void removeAction(StartupModel model, boolean fireChange) {
        int index = this.actions.indexOf(model);
        this.actions.remove(model);
        this.setRestartRequired();
        if (fireChange) {
            this.fireIndexedPropertyChange(STARTUP, index, model, null);
        }
    }

    public HashMap<Class<? extends StartupModel>, StartupModelFactory> getFactories() {
        return new HashMap<Class<? extends StartupModel>, StartupModelFactory>(this.factories);
    }

    public StartupModelFactory getFactories(Class<? extends StartupModel> model) {
        return this.factories.get(model);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setRestartRequired() {
        this.restartRequired = true;
        this.isDirty = true;
    }

    public boolean isRestartRequired() {
        return this.isDirty || this.restartRequired;
    }
}

