/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.FlowLayout;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProvidingManager;
import jmri.ProxyManager;
import jmri.UserPreferencesManager;
import jmri.swing.ManagerComboBox;
import jmri.swing.NamedBeanComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSelectCreatePanel<E extends NamedBean>
extends JPanel {
    E _defaultSelect;
    String _reference = null;
    JRadioButton existingItem = new JRadioButton();
    JRadioButton newItem;
    ButtonGroup selectcreate = new ButtonGroup();
    NamedBeanComboBox<E> existingCombo;
    JTextField hardwareAddress = new JTextField(8);
    ManagerComboBox<E> prefixBox = new ManagerComboBox();
    String systemSelectionCombo = this.getClass().getName() + ".SystemSelected";
    private static final Logger log = LoggerFactory.getLogger((String)BeanSelectCreatePanel.class.getName());

    public BeanSelectCreatePanel(@Nonnull Manager<E> manager, E defaultSelect) {
        this._defaultSelect = defaultSelect;
        UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        this.existingItem = new JRadioButton(Bundle.getMessage("UseExisting"), true);
        this.newItem = new JRadioButton(Bundle.getMessage("CreateNew"));
        this.existingItem.addActionListener(e -> this.update());
        this.newItem.addActionListener(e -> this.update());
        this.selectcreate.add(this.existingItem);
        this.selectcreate.add(this.newItem);
        this.existingCombo = new NamedBeanComboBox<E>(manager, defaultSelect, NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        if (this.existingCombo.getItemCount() == 0) {
            this.newItem.setSelected(true);
        }
        this.existingCombo.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.existingCombo);
        JPanel radio = new JPanel();
        radio.setLayout(new FlowLayout(1, 5, 0));
        JPanel bean = new JPanel();
        bean.setLayout(new FlowLayout(1, 5, 0));
        radio.add(this.existingItem);
        radio.add(this.newItem);
        if (manager instanceof ProxyManager) {
            ProxyManager proxy = (ProxyManager)manager;
            this.prefixBox.setManagers(proxy.getManagerList(), proxy.getDefaultManager());
            if (p.getComboBoxLastSelection(this.systemSelectionCombo) != null) {
                this.prefixBox.setSelectedItem(p.getComboBoxLastSelection(this.systemSelectionCombo));
            }
        } else {
            this.prefixBox.setManagers(manager);
        }
        bean.add(this.existingCombo);
        bean.add(this.prefixBox);
        bean.add(this.hardwareAddress);
        this.hardwareAddress.setToolTipText(Bundle.getMessage("EnterHWaddressAsIntTooltip"));
        SystemNameValidator validator = new SystemNameValidator(this.hardwareAddress, (Manager<?>)this.prefixBox.getSelectedItem());
        this.prefixBox.addItemListener(e -> validator.setManager((Manager<?>)this.prefixBox.getSelectedItem()));
        this.hardwareAddress.setInputVerifier((InputVerifier)((Object)validator));
        super.setLayout(new BoxLayout(this, 1));
        super.add(radio);
        super.add(bean);
        this.update();
    }

    void update() {
        boolean select = true;
        if (this.newItem.isSelected()) {
            select = false;
        }
        this.prefixBox.setVisible(false);
        this.hardwareAddress.setVisible(false);
        this.existingCombo.setVisible(false);
        if (select) {
            this.existingCombo.setVisible(true);
        } else {
            this.prefixBox.setVisible(true);
            this.hardwareAddress.setVisible(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.existingItem.setEnabled(enabled);
        this.hardwareAddress.setEnabled(enabled);
        this.prefixBox.setEnabled(enabled);
        this.newItem.setEnabled(enabled);
        this.existingCombo.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public String getDisplayName() {
        if (this.existingItem.isSelected()) {
            return this.existingCombo.getSelectedItemDisplayName();
        }
        try {
            E nBean = this.createBean();
            return nBean.getDisplayName();
        }
        catch (JmriException e) {
            return "";
        }
    }

    public boolean hasBeanOrBeanName() {
        return this.existingItem.isSelected() || !this.hardwareAddress.getText().trim().isEmpty();
    }

    public E getNamedBean() throws JmriException {
        if (this.existingItem.isSelected()) {
            return (E)this.existingCombo.getSelectedItem();
        }
        return this.createBean();
    }

    private E createBean() throws JmriException {
        Object manager = this.prefixBox.getSelectedItem();
        E nBean = null;
        if (manager instanceof ProvidingManager) {
            ProvidingManager provider = (ProvidingManager)manager;
            try {
                nBean = provider.provide(provider.makeSystemName(this.hardwareAddress.getText()));
            }
            catch (IllegalArgumentException ex) {
                throw new JmriException(ex);
            }
        }
        if (nBean == null) {
            throw new JmriException("Unable to create bean");
        }
        this.updateComment(nBean, this._reference);
        this.setDefaultNamedBean(nBean);
        return nBean;
    }

    public void setReference(String ref) {
        this._reference = ref;
    }

    public void setDefaultNamedBean(E nBean) {
        this._defaultSelect = nBean;
        this.existingCombo.setSelectedItem(this._defaultSelect);
        this.existingItem.setSelected(true);
        this.update();
    }

    public boolean isEmpty() {
        if (this.existingItem.isSelected() && this.existingCombo.getSelectedItem() != null) {
            log.debug("existingCombo.getSelectedBean() = {}", (Object)this.existingCombo.getSelectedItem().getDisplayName());
            return false;
        }
        if (this.newItem.isSelected() && !this.hardwareAddress.getText().isEmpty() && this.hardwareAddress.getText() != null) {
            log.debug("newBeanEntry = {}", (Object)this.hardwareAddress.getText());
            return false;
        }
        return true;
    }

    public void updateComment(@Nonnull E nBean, String content) {
        String comment = nBean.getComment();
        log.debug("comment {}", (Object)(comment == null || comment.isEmpty() ? "was empty" : "already filled"));
        if (content != null && !content.isEmpty() && (comment == null || comment.isEmpty())) {
            log.debug("new comment added to bean {}", (Object)nBean.getDisplayName());
            nBean.setComment(content);
        } else {
            log.debug("empty _reference received");
        }
    }

    public void dispose() {
        this.existingCombo.dispose();
    }
}

