/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.swing.Bundle;

public class ButtonGroupColorChooserPanel
extends AbstractColorChooserPanel {
    private String[] colorText = new String[]{"Black", "DarkGray", "Gray", "LightGray", "White", "Red", "Pink", "Orange", "Yellow", "Green", "Blue", "Magenta", "Cyan"};
    private Color[] colorCode = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.blue, Color.magenta, Color.cyan};
    private int numColors = 13;
    private ButtonGroup colorButtonGroup = null;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        for (int i = 0; i < this.numColors; ++i) {
            if (!color.equals(this.colorCode[i])) continue;
            String buttonLabel = Bundle.getMessage(this.colorText[i]);
            Enumeration<AbstractButton> e = this.colorButtonGroup.getElements();
            while (e.hasMoreElements()) {
                JRadioButton button = (JRadioButton)e.nextElement();
                if (!buttonLabel.equals(button.getText())) continue;
                button.setSelected(true);
                return;
            }
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BoxLayout(this, 3));
        this.colorButtonGroup = new ButtonGroup();
        for (int i = 0; i < this.numColors; ++i) {
            this.addButton(this.colorButtonGroup, this.colorCode[i], Bundle.getMessage(this.colorText[i]));
        }
    }

    private void addButton(ButtonGroup bg, Color color, String buttonLabel) {
        JRadioButton button = new JRadioButton(buttonLabel);
        button.addActionListener(e -> this.getColorSelectionModel().setSelectedColor(color));
        bg.add(button);
        this.add(button);
    }

    @Override
    public String getDisplayName() {
        return Bundle.getMessage("ButtonGroupColorChooserName");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

