/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawSquares {
    private static final Logger log = LoggerFactory.getLogger(DrawSquares.class);

    public static BufferedImage getImage(int width, int height, int dim, Color color1, Color color2) {
        Color sqColor = new Color(235, 235, 235);
        Color bgColor = Color.white;
        int w = 500;
        int h = 500;
        if (width > 0) {
            w = width;
        }
        if (height > 0) {
            h = height;
        }
        if (color1 != null) {
            bgColor = color1;
        }
        if (color2 != null) {
            sqColor = color2;
        }
        BufferedImage result = new BufferedImage(w, h, 1);
        Graphics2D g2d = result.createGraphics();
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, w, h);
        if (sqColor != bgColor) {
            g2d.setColor(sqColor);
            for (int j = 0; j <= w / dim; ++j) {
                for (int k = 0; k <= h / dim; ++k) {
                    if ((j + k) % 2 != 0) continue;
                    g2d.fillRect(j * dim, k * dim, dim, dim);
                }
            }
        }
        g2d.dispose();
        log.debug("DrawSquares ready");
        return result;
    }
}

