/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import javax.annotation.Nonnull;
import jmri.jmrit.mailreport.ReportContext;
import jmri.util.StringUtil;

public class ExceptionContext {
    protected final Throwable exception;
    protected String prefaceString = "An error occurred during the following operation.";
    protected String operation;
    protected String hint = "";

    public ExceptionContext(@Nonnull Throwable ex, @Nonnull String operation, @Nonnull String hint) {
        this.exception = ex;
        this.operation = operation;
        this.hint = hint;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getPreface() {
        return this.prefaceString;
    }

    public String getOperation() {
        return this.operation;
    }

    @Nonnull
    public String getHint() {
        return this.hint;
    }

    public String getTitle() {
        String msg = this.exception.getLocalizedMessage();
        return msg.substring(0, Math.min(msg.length(), 80));
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.getPreface().isBlank()) {
            sb.append(this.getPreface()).append(System.lineSeparator()).append(System.lineSeparator());
        }
        if (!this.getOperation().isBlank()) {
            sb.append(this.getOperation()).append(System.lineSeparator());
        }
        if (!this.getHint().isBlank()) {
            sb.append(this.getHint()).append(System.lineSeparator());
        }
        if (!this.getException().getMessage().equals(this.getException().getLocalizedMessage())) {
            sb.append(this.getException().getLocalizedMessage()).append(System.lineSeparator());
        }
        sb.append(this.getException().getMessage()).append(System.lineSeparator());
        sb.append(this.getException().getClass().getName()).append(System.lineSeparator());
        Throwable cause = this.getException().getCause();
        if (cause != null) {
            sb.append(cause.toString()).append(System.lineSeparator());
        }
        sb.append(this.getException().toString());
        return StringUtil.stripHtmlTags(sb.toString());
    }

    public String getStackTraceAsString(int maxLevels) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stElements = this.exception.getStackTrace();
        int limit = Math.min(maxLevels, stElements.length);
        for (int i = 0; i < limit; ++i) {
            sb.append(" at ");
            sb.append(stElements[i].toString());
            sb.append(System.lineSeparator());
        }
        if (stElements.length > limit) {
            sb.append(" plus ");
            sb.append(stElements.length - limit);
            sb.append(" more.");
        }
        return sb.toString();
    }

    public String getStackTraceString() {
        return this.getStackTraceAsString(Integer.MAX_VALUE);
    }

    public String getClipboardString(boolean includeSysInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary());
        sb.append(System.lineSeparator());
        sb.append(this.getStackTraceString());
        if (includeSysInfo) {
            sb.append(System.lineSeparator());
            sb.append(new ReportContext().getReport(true));
        }
        return sb.toString();
    }
}

