/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jmri.util.swing.Bundle;
import jmri.util.swing.ExceptionContext;
import jmri.util.swing.JmriJOptionPane;

public class ExceptionDisplayFrame {
    private static final EmptyBorder border = new EmptyBorder(10, 20, 10, 20);

    private ExceptionDisplayFrame() {
    }

    public static void displayExceptionDisplayFrame(@CheckForNull Component owner, @Nonnull ExceptionContext context) {
        JmriJOptionPane.showMessageDialog(owner, ExceptionDisplayFrame.initComponents(context), context.getTitle(), 0);
    }

    public static void displayExceptionDisplayFrame(@CheckForNull Component owner, @Nonnull Exception ex) {
        ExceptionDisplayFrame.displayExceptionDisplayFrame(owner, new ExceptionContext(ex, "", ""));
    }

    @Nonnull
    private static JPanel initComponents(@Nonnull ExceptionContext context) {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(border);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.add(new JLabel("<html><h2>" + context.getPreface() + "</h2></html>"));
        contentPane.add(titlePanel);
        if (!context.getHint().isBlank()) {
            JPanel hintPanel = new JPanel();
            hintPanel.add(new JLabel("<html><h3>" + context.getHint() + "</h3></html>"));
            contentPane.add(hintPanel);
        }
        contentPane.add(ExceptionDisplayFrame.getSummaryPanel(context));
        contentPane.add(ExceptionDisplayFrame.getButtonPanel(context));
        contentPane.add(ExceptionDisplayFrame.getStrackTracePanel(context));
        return contentPane;
    }

    @Nonnull
    private static JPanel getSummaryPanel(@Nonnull ExceptionContext context) {
        JPanel summaryPanel = new JPanel();
        JTextArea jta = new JTextArea(context.getSummary());
        jta.setBorder(border);
        summaryPanel.add(jta);
        return summaryPanel;
    }

    @Nonnull
    private static JPanel getStrackTracePanel(@Nonnull ExceptionContext context) {
        JPanel strackTracePanel = new JPanel();
        JTextArea ta = new JTextArea(context.getStackTraceAsString(10));
        ta.setToolTipText(Bundle.getMessage("ExceptionDisplayStackTraceToolTip"));
        ta.setBorder(border);
        strackTracePanel.add(ta);
        return strackTracePanel;
    }

    @Nonnull
    private static JPanel getButtonPanel(@Nonnull ExceptionContext context) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        JButton exCopyButton = new JButton(Bundle.getMessage("ExceptionDisplayCopyButton"));
        exCopyButton.addActionListener(e -> systemClipboard.setContents(new StringSelection(context.getClipboardString(false)), null));
        JButton systemCopyButton = new JButton(Bundle.getMessage("ExceptionSystemCopyButton"));
        systemCopyButton.addActionListener(e -> systemClipboard.setContents(new StringSelection(context.getClipboardString(true)), null));
        JPanel b1 = new JPanel();
        JPanel b2 = new JPanel();
        b1.add(exCopyButton);
        b2.add(systemCopyButton);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(b1);
        p.add(b2);
        return p;
    }
}

