/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jmri.util.ThreadingUtil;
import jmri.util.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontComboUtil {
    public static final int ALL = 0;
    public static final int MONOSPACED = 1;
    public static final int PROPORTIONAL = 2;
    public static final int CHARACTER = 3;
    public static final int SYMBOL = 4;
    private static final List<String> all = new ArrayList<String>();
    private static final List<String> monospaced = new ArrayList<String>();
    private static final List<String> proportional = new ArrayList<String>();
    private static final List<String> character = new ArrayList<String>();
    private static final List<String> symbol = new ArrayList<String>();
    private static volatile boolean prepared = false;
    private static volatile boolean preparing = false;
    private static final Logger log = LoggerFactory.getLogger(FontComboUtil.class);

    public static List<String> getFonts(int which) {
        FontComboUtil.prepareFontLists();
        switch (which) {
            case 1: {
                return new ArrayList<String>(monospaced);
            }
            case 2: {
                return new ArrayList<String>(proportional);
            }
            case 3: {
                return new ArrayList<String>(character);
            }
            case 4: {
                return new ArrayList<String>(symbol);
            }
        }
        return new ArrayList<String>(all);
    }

    public static boolean isSymbolFont(String font) {
        FontComboUtil.prepareFontLists();
        return symbol.contains(font);
    }

    public static void prepareFontLists() {
        if (prepared || preparing) {
            log.debug("Subsequent call - no need to prepare");
            return;
        }
        FontComboUtil.initFonts();
    }

    private static synchronized void initFonts() {
        preparing = true;
        log.debug("Prepare font lists...");
        FontComboUtil.initAllFonts();
        Canvas c = new Canvas();
        all.forEach(s -> {
            Font f = new Font((String)s, 0, 12);
            FontMetrics fm = c.getFontMetrics(f);
            if (f.canDisplay('F') && f.canDisplay('b') && f.canDisplay('8')) {
                character.add((String)s);
                int w = fm.charWidth('I');
                if (fm.charWidth('W') == w && fm.charWidth(' ') == w) {
                    monospaced.add((String)s);
                } else {
                    proportional.add((String)s);
                }
            } else {
                symbol.add((String)s);
            }
        });
        log.debug("...font lists built");
        prepared = true;
    }

    private static synchronized void initAllFonts() {
        if (all.isEmpty()) {
            all.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        }
    }

    public static JComboBox<String> getFontCombo() {
        FontComboUtil.initAllFonts();
        return FontComboUtil.getFontCombo(0);
    }

    public static JComboBox<String> getFontCombo(boolean previewOnly) {
        FontComboUtil.initAllFonts();
        return FontComboUtil.getFontCombo(0, previewOnly);
    }

    public static JComboBox<String> getFontCombo(int which) {
        return FontComboUtil.getFontCombo(which, true);
    }

    public static JComboBox<String> getFontCombo(int which, boolean previewOnly) {
        return FontComboUtil.getFontCombo(which, 0, previewOnly);
    }

    public static JComboBox<String> getFontCombo(int which, int size) {
        return FontComboUtil.getFontCombo(which, size, true);
    }

    public static JComboBox<String> getFontCombo(int which, int size, boolean previewOnly) {
        FontComboUtil.prepareFontLists();
        List<String> fonts = FontComboUtil.getFonts(which);
        JComboBox<String> fontList = new JComboBox<String>(fonts.toArray(new String[fonts.size()]));
        fontList.setRenderer((list, family, index, isSelected, hasFocus) -> {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.setOpaque(index > -1);
            if (isSelected && index > -1) {
                p.setBackground(list.getSelectionBackground());
                p.setForeground(list.getSelectionForeground());
            } else {
                p.setBackground(list.getBackground());
                p.setForeground(list.getForeground());
            }
            JLabel name = new JLabel(family + (previewOnly || index == -1 ? "" : ": "));
            JLabel preview = new JLabel((String)family);
            name.setFont(list.getFont());
            if (FontComboUtil.isSymbolFont(family)) {
                preview.setFont(list.getFont());
                preview.setText(family + " " + Bundle.getMessage("FontSymbol"));
            } else {
                preview.setFont(new Font((String)family, 0, size == 0 ? list.getFont().getSize() : size));
            }
            name.setPreferredSize(new Dimension(index == -1 && !previewOnly ? name.getMaximumSize().width * 2 : name.getMaximumSize().width, name.getMaximumSize().height + 4));
            preview.setPreferredSize(new Dimension(name.getMaximumSize().width, preview.getMaximumSize().height));
            name.setAlignmentY(0.5f);
            preview.setAlignmentY(0.5f);
            name.setForeground(p.getForeground());
            preview.setForeground(p.getForeground());
            if (!previewOnly && index > -1) {
                p.add(name);
                p.add(preview);
            } else if (index == -1) {
                name.setPreferredSize(new Dimension(name.getPreferredSize().width + 20, name.getPreferredSize().height - 2));
                p.add(name);
            } else {
                p.add(preview);
            }
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif") && index == -1) {
                return name;
            }
            return p;
        });
        return fontList;
    }

    public static boolean isReady() {
        if (!prepared && !preparing) {
            ThreadingUtil.newThread(() -> FontComboUtil.prepareFontLists(), "FontComboUtil Prepare").start();
        }
        return prepared;
    }
}

