/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePanel
extends JPanel {
    private BufferedImage back = null;
    private BufferedImage clip = null;
    private static final Logger log = LoggerFactory.getLogger(ImagePanel.class);

    public void setImage(Image img) {
        if (!(img instanceof BufferedImage)) {
            throw new IllegalArgumentException("Not a Buffered Image: " + img);
        }
        this.back = (BufferedImage)img;
        this.repaint();
        log.debug("DrawPanel ready");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.back != null) {
            int imgWidth = this.back.getWidth(this);
            int imgHeight = this.back.getHeight(this);
            double frameRatio = (double)this.getWidth() / (double)this.getHeight();
            double imgRatio = (double)imgWidth / (double)imgHeight;
            log.debug("ratios: fr {} - img {}", (Object)frameRatio, (Object)imgRatio);
            if (frameRatio < imgRatio) {
                imgWidth = (int)((double)imgHeight * frameRatio);
            } else {
                imgHeight = (int)((double)imgWidth / frameRatio);
            }
            this.clip = new BufferedImage(imgWidth, imgHeight, 1);
            this.clip = this.back.getSubimage(0, 0, Math.min(imgWidth, this.back.getWidth(this)), Math.min(imgHeight, this.back.getHeight(this)));
            g.drawImage(this.clip, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }
}

