/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import jmri.InstanceManager;
import jmri.util.SystemType;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.GuiUtilBase;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMenuUtil
extends GuiUtilBase {
    private static final Logger log = LoggerFactory.getLogger(JMenuUtil.class);

    public static JMenu[] loadMenu(String path, WindowInterface wi, Object context) {
        Element root = JMenuUtil.rootFromName(path);
        int n = root.getChildren("node").size();
        JMenu[] retval = new JMenu[n];
        int i = 0;
        ArrayList<Integer> mnemonicList = new ArrayList<Integer>();
        for (Object child : root.getChildren("node")) {
            JMenu menuItem = JMenuUtil.jMenuFromElement((Element)child, wi, context);
            retval[i++] = menuItem;
            if (((Element)child).getChild("mnemonic") == null) continue;
            int mnemonic = JMenuUtil.convertStringToKeyEvent(((Element)child).getChild("mnemonic").getText());
            if (mnemonicList.contains(mnemonic)) {
                log.error("Menu item '{}' Mnemonic '{}' has already been assigned", (Object)menuItem.getText(), (Object)((Element)child).getChild("mnemonic").getText());
                continue;
            }
            menuItem.setMnemonic(mnemonic);
            mnemonicList.add(mnemonic);
        }
        return retval;
    }

    @Nonnull
    static JMenu jMenuFromElement(@CheckForNull Element main, WindowInterface wi, Object context) {
        boolean addSep = false;
        String name = "<none>";
        if (main == null) {
            log.warn("Menu from element called without an element");
            return new JMenu(name);
        }
        name = LocaleSelector.getAttribute(main, "name");
        if ((name == null || name.equals("")) && main.getChild("name") != null) {
            name = main.getChild("name").getText();
        }
        JMenu menu = new JMenu(name);
        ArrayList<Integer> mnemonicList = new ArrayList<Integer>();
        for (Object item : main.getChildren("node")) {
            JMenuItem menuItem = null;
            Element child = (Element)item;
            if (child.getChildren("node").isEmpty()) {
                if (child.getText().trim().equals("separator")) {
                    addSep = true;
                } else {
                    boolean optional = true;
                    Element instanceManagerOptionalClassElement = child.getChild("instanceManagerOptionalClass");
                    Element optionalFunctionElement = child.getChild("optionalFunction");
                    if (instanceManagerOptionalClassElement != null && optionalFunctionElement != null) {
                        String instanceManagerOptional = instanceManagerOptionalClassElement.getText();
                        String optionalFunction = optionalFunctionElement.getText();
                        Object o = InstanceManager.getDefault(instanceManagerOptional);
                        try {
                            Method method = o.getClass().getDeclaredMethod(optionalFunction, new Class[0]);
                            Object result = method.invoke(o, new Object[0]);
                            if (result instanceof Boolean) {
                                optional = (Boolean)result;
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            log.error("Error during loading of menu", (Throwable)e);
                        }
                    }
                    if (!(SystemType.isMacOSX() && UIManager.getLookAndFeel().isNativeLookAndFeel() && (child.getChild("adapter") != null && child.getChild("adapter").getText().equals("apps.gui3.tabbedpreferences.TabbedPreferencesAction") || child.getChild("current") != null && child.getChild("current").getText().equals("quit")) || !optional)) {
                        if (addSep) {
                            menu.addSeparator();
                            addSep = false;
                        }
                        Action act = JMenuUtil.actionFromNode(child, wi, context);
                        menuItem = new JMenuItem(act);
                        menu.add(menuItem);
                    }
                }
            } else {
                if (addSep) {
                    menu.addSeparator();
                    addSep = false;
                }
                if (child.getChild("group") != null && child.getChild("group").getText().equals("yes")) {
                    menu.add(JMenuUtil.createMenuGroupFromElement(child, wi, context));
                } else {
                    menuItem = JMenuUtil.jMenuFromElement(child, wi, context);
                    menu.add(menuItem);
                }
            }
            if (menuItem != null && child.getChild("current") != null) {
                JMenuUtil.setMenuItemInterAction(context, child.getChild("current").getText(), menuItem);
            }
            if (menuItem == null || child.getChild("mnemonic") == null) continue;
            int mnemonic = JMenuUtil.convertStringToKeyEvent(child.getChild("mnemonic").getText());
            if (mnemonicList.contains(mnemonic)) {
                log.error("Menu Item '{}' Mnemonic '{}' has already been assigned", (Object)menuItem.getText(), (Object)child.getChild("mnemonic").getText());
                continue;
            }
            menuItem.setMnemonic(mnemonic);
            mnemonicList.add(mnemonic);
        }
        return menu;
    }

    @Nonnull
    static JMenu createMenuGroupFromElement(@CheckForNull Element main, WindowInterface wi, Object context) {
        String name = "<none>";
        if (main == null) {
            log.warn("Menu from element called without an element");
            return new JMenu(name);
        }
        name = LocaleSelector.getAttribute(main, "name");
        if ((name == null || name.equals("")) && main.getChild("name") != null) {
            name = main.getChild("name").getText();
        }
        JMenu menu = new JMenu(name);
        ButtonGroup group = new ButtonGroup();
        for (Object item : main.getChildren("node")) {
            Element elem = (Element)item;
            Action act = JMenuUtil.actionFromNode(elem, wi, context);
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(act);
            group.add(menuItem);
            menu.add(menuItem);
            if (elem.getChild("current") == null) continue;
            JMenuUtil.setMenuItemInterAction(context, elem.getChild("current").getText(), menuItem);
        }
        return menu;
    }

    static void setMenuItemInterAction(@Nonnull Object context, final String ref, final JMenuItem menuItem) {
        Method methodListener = null;
        try {
            methodListener = context.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
        }
        catch (NullPointerException e) {
            log.error("Null object passed");
            return;
        }
        catch (SecurityException e) {
            log.error("security exception unable to find remoteCalls for {}", (Object)context.getClass().getName());
            return;
        }
        catch (NoSuchMethodException e) {
            log.error("No such method remoteCalls for {}", (Object)context.getClass().getName());
            return;
        }
        try {
            methodListener.invoke(context, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals(ref)) {
                        String method = (String)e.getOldValue();
                        if (method.equals("setSelected")) {
                            menuItem.setSelected(true);
                        } else if (method.equals("setEnabled")) {
                            menuItem.setEnabled((Boolean)e.getNewValue());
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException ex) {
            log.error("IllegalArgument in setMenuItemInterAction ", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            log.error("IllegalAccess in setMenuItemInterAction ", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            log.error("InvocationTarget {} in setMenuItemInterAction ", (Object)ref, (Object)ex);
        }
        catch (NullPointerException ex) {
            log.error("NPE {} in setMenuItemInterAction ", (Object)context.getClass().getName(), (Object)ex);
        }
    }

    static int convertStringToKeyEvent(@Nonnull String st) {
        char a = st.toLowerCase().charAt(0);
        int kcode = a - 32;
        return kcode;
    }

    public static boolean replaceMenuItem(@Nonnull JMenuItem orginalMenuItem, @Nonnull JMenuItem replacementMenuItem) {
        int index;
        boolean result = false;
        Container container = orginalMenuItem.getParent();
        if (container != null && (index = container.getComponentZOrder(orginalMenuItem)) > -1) {
            container.remove(orginalMenuItem);
            container.add((Component)replacementMenuItem, index);
            result = true;
        }
        return result;
    }
}

