/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmriAbstractAction
extends AbstractAction {
    protected WindowInterface.Hint hint = WindowInterface.Hint.DEFAULT;
    protected WindowInterface wi;
    protected Object context = null;
    private static final Logger log = LoggerFactory.getLogger(JmriAbstractAction.class);
    JmriPanel cache = null;

    public JmriAbstractAction(String name, WindowInterface wi) {
        super(name);
        this.wi = wi;
        if (wi == null) {
            log.error("Cannot create action with null WindowInterface", (Throwable)new Exception());
        }
    }

    public JmriAbstractAction(String s, Icon i, WindowInterface wi) {
        super(s, i);
        this.wi = wi;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public JmriAbstractAction(String name) {
        super(name);
        this.wi = new JmriJFrameInterface();
    }

    public void setWindowInterface(WindowInterface wi) {
        this.wi = wi;
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    public JmriAbstractAction setHint(WindowInterface.Hint hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.cache == null || this.wi.multipleInstances() && this.cache.isMultipleInstances()) {
            try {
                this.cache = this.makePanel();
            }
            catch (Exception ex) {
                log.error("Exception creating panel", (Throwable)ex);
                return;
            }
            if (this.cache == null) {
                log.error("Unable to make panel");
                return;
            }
        }
        this.wi.show(this.cache, this, this.hint);
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
    }

    public void setParameter(String parameter, String value) {
    }

    public void setParameter(String parameter, Object value) {
    }

    public abstract JmriPanel makePanel();
}

